/* PSMatrix.h --- linear operator 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_MATRIX_H
#define P_S_MATRIX_H 

#include <gyve/utilities.h>
#include <gyve/GyveVisitor.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSConcreteValue.h>

enum matrix_type {C_MATRIX, OBJC_MATRIX};

@protocol PSMatrix
- (void)setMatrixElement: (float)element
		 atIndex: (enum matrix_element_index)index ;
- (float)matrixElementAtIndex: (enum matrix_element_index)index;
- (void)setMatrix: (void *)m ofType: (enum matrix_type) t;
- (void)getMatrixValue: (float *)m;
- (void)applyMatrixTo: (NSPoint *)target result: (NSPoint *) result;
@end

@interface PSMatrix: NSConcreteValue
- init;
- initWithMatrix: (float *)matrix;
- initWithMatrixElementA: (float)a
		       B: (float)b
		       C: (float)c
		       D: (float)d
		      TX: (float)tx
		      TY: (float)ty;
@end

@interface NSValue(PSMatrix)<PSMatrix>
+ (NSValue *)valueWithMatrix: (float *)matrix;
- (float *)matrixValue;
- (float)matrixElementAtIndex: (enum matrix_element_index)index;
- (void)setMatrixElement: (float)element
		 atIndex: (enum matrix_element_index)index ;
- (void)setMatrix: (void *)m ofType: (enum matrix_type) t;
- (void)getMatrixValue: (float *)m;
- (void)applyMatrixTo: (NSPoint *)target result: (NSPoint *) result;
@end

@interface PSMatrixApplier: GyveVisitor<PSMatrix>
{
  /* Ŭʿ԰ư*/
  NSPoint delta_from_origin;
  enum matrix_type type;	// Use @encode instead...
  union 
  {
    float c[6];
    NSObject<PSMatrix> * objc;
  } matrix;
  
}
- initWithVisitingTarget: (NSObject <FigObjsContaining>*)_target;
- (void)dealloc;
- (void)setMatrix: (void *)m ofType: (enum matrix_type) t;
- (void)setMatrixElement: (float)element
		 atIndex: (enum matrix_element_index)index ;
- (float)matrixElementAtIndex: (enum matrix_element_index)index;
- (void)setDeltaFromOriginX: (float)x Y: (float)y;
- (NSPoint *)deltaFromOrigin;
- (void)setMatrixElement: (float)element
		 atIndex: (enum matrix_element_index)index;
@end
#endif /* Not def: P_S_MATRIX_H */
