/* PSPaintStyle.h --- 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_PAINT_STYLE_H
#define P_S_PAINT_STYLE_H 
#include <gyve/utilities.h>
#include <Foundation/NSObject.h>
#include <gyve/GyveVisitor.h>

enum ps_line_join {mitered_joins  = 0, round_joins, beveled_joins};
enum ps_line_cap {butt_end_caps = 0, round_end_caps, square_end_caps}; 

@protocol PSPaintStyle
- (void)installPaintStyle: (id<PSPaintStyle>)base_style; 
- (void)setLineJoin: (enum ps_line_join)lj;
- (void)setLineCap: (enum ps_line_cap)lc;
- (void)setMiterLimit: (float)ml;
- (void)setLineWidth:(float)width;
- (enum ps_line_join)lineJoin;
- (enum ps_line_cap)lineCap;
- (float)miterLimit;
- (float)lineWidth;
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s;
- (NSObject<NSCopying>*)stroking;
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f;
- (NSObject<NSCopying>*)filling;
@end

@interface PSPaintStyle: NSObject<NSCopying, PSPaintStyle>
{
  enum ps_line_join line_join;
  enum ps_line_cap line_cap;
  float miter_limit;
  float line_width;
  float flatness; 
  NSObject* stroking;
  NSObject* filling;
}
- init;
- initWithPaintStyle: (BYCOPY id<PSPaintStyle>)base_style;
- (void)installPaintStyle: (BYCOPY id<PSPaintStyle>)base_style; 
- (void)setLineJoin: (enum ps_line_join)lj;
- (enum ps_line_join)lineJoin;
- (void)setLineCap: (enum ps_line_cap)lc;
- (enum ps_line_cap)lineCap;
- (void)setMiterLimit: (float)ml;
- (float)miterLimit;
- (void)setLineWidth:(float)width;
- (float)lineWidth;
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s;
- (NSObject<NSCopying>*)stroking;
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f;
- (NSObject<NSCopying>*)filling;
- (void)dealloc;
@end

@interface PSPaintStyleApplier: GyveVisitor<PSPaintStyle>
{
  SEL operator;
  PSPaintStyle * paint_style;
}
- initWithVisitingTarget: (NSObject <FigObjsContaining>*)_target;
- (void)installPaintStyle: (BYCOPY id<PSPaintStyle>)base_style; 
- (void)setLineJoin: (enum ps_line_join)lj;
- (void)setLineCap: (enum ps_line_cap)lc;
- (void)setMiterLimit: (float)ml;
- (void)setLineWidth:(float)width;
- (enum ps_line_join)lineJoin;
- (enum ps_line_cap)lineCap;
- (float)miterLimit;
- (float)lineWidth;
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s;
- (NSObject<NSCopying>*)stroking;
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f;
- (NSObject<NSCopying>*)filling;
@end

#endif /* Not def: P_S_PAINT_STYLE_H */
