/* PSPaintStyle.m --- The definition for text 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSPaintStyle.h"
#include "PSPath.h"
#include "PSTextElement.h"

@implementation PSPaintStyle
- init
{
  [super init];
  line_join   = mitered_joins;
  line_cap    = butt_end_caps;
  miter_limit = 10.0;
  line_width = 1.0;		
  stroking   = nil;
  filling    = nil;
  return self ;
}
- initWithPaintStyle: (BYCOPY id<PSPaintStyle>)base_style
{
  [self init];
  [self installPaintStyle: base_style];
  return self ;
}
- (void)installPaintStyle: (BYCOPY id<PSPaintStyle>)base_style
{
  if (base_style == self) return ;
  [self setLineJoin: [base_style lineJoin]];
  [self setLineCap: [base_style lineCap]];
  [self setMiterLimit: [base_style miterLimit]];
  [self setLineWidth: [base_style lineWidth]];
  [self setFilling: [base_style filling]];
  [self setStroking: [base_style stroking]];
}
- (void)setLineJoin: (enum ps_line_join)lj
{
  line_join = lj;
}
- (enum ps_line_join)lineJoin
{
  return line_join;
}
- (void)setLineCap: (enum ps_line_cap)lc
{
  line_cap = lc;
}
- (enum ps_line_cap)lineCap
{
  return line_cap;
}
- (void)setMiterLimit: (float)ml
{
  miter_limit = ml;
}
- (float)miterLimit
{
  return miter_limit;
}
- (void)setLineWidth:(float)width
{
  // TODO width < 0.0ξexception
  line_width = width;
}
- (float)lineWidth
{
  return line_width;
}
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f
{
  id new = [[f copy] autorelease];
  ASSIGN(filling, new);
}
- (NSObject<NSCopying>*)filling
{
  return filling;
}
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s
{
  id new = [[s copy] autorelease];
   ASSIGN(stroking, new);
}
- (NSObject<NSCopying>*)stroking
{
  return stroking;
}
- (void)dealloc
{
  DESTROY(stroking);
  DESTROY(filling);
  [super dealloc];
}
- copyWithZone:(NSZone *)zone
{
  return [[[self class] allocWithZone: zone] initWithPaintStyle: self];
}
@end

@implementation  PSPaintStyleApplier
- initWithVisitingTarget: (NSObject <FigObjsContaining>*)_target
{
  [super initWithVisitingTarget: _target];
  operator    = (SEL)0;
  paint_style = [[PSPaintStyle alloc] init];
  return self;
}
- (void)dealloc
{
  operator 			     = 0;
  [paint_style release], paint_style = nil;
  [super dealloc];
}
- (void)installPaintStyle: (BYCOPY id<PSPaintStyle>)base_style
{
  operator = _cmd;
  [paint_style installPaintStyle: base_style];
  [self visitDownward];
}
- (void)setLineJoin: (enum ps_line_join)lj
{
  operator = _cmd;
  [paint_style setLineJoin: lj];
  [self visitDownward];
}
- (void)setLineCap: (enum ps_line_cap)lc
{
  operator = _cmd;
  [paint_style setLineCap: lc];
  [self visitDownward];
}
- (void)setMiterLimit: (float)ml
{
  operator = _cmd;
  [paint_style setMiterLimit: ml];
  [self visitDownward];
}
- (void)setLineWidth:(float)width
{
  operator = _cmd;
  [paint_style setLineWidth: width];
  [self visitDownward];
}
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s
{
  operator = _cmd;
  [paint_style setStroking: s];
  [self visitDownward];
}
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f
{
  operator = _cmd;
  [paint_style setFilling: f];
  [self visitDownward];
}
- (enum ps_line_join)lineJoin
{
  return [paint_style lineJoin];
}
- (enum ps_line_cap)lineCap
{
  return [paint_style lineCap];
}
- (float)miterLimit
{
  return [paint_style miterLimit];
}
- (float)lineWidth
{
  return [paint_style lineWidth];
}
- (NSObject<NSCopying>*)stroking
{
  return [paint_style stroking];
}

- (NSObject<NSCopying>*)filling
{
  return [paint_style filling];
}
/*
 * GyveVisitor
 */
- (enum gyve_visitor_request)visitAtPath:(PSPath *)path
{
  PSPaintStyle * path_paint_style;
  if (operator == (SEL)0)  return visitor_continue; // ???
  
  path_paint_style = [path paintStyle];
  
  if (YES == sel_eq(operator, @selector(installPaintStyle:)))
    {
      [path_paint_style installPaintStyle: paint_style];
    }
  else if (YES == sel_eq(@selector(setLineJoin:), operator))
    {
      [path_paint_style setLineJoin: [paint_style lineJoin]];
    }
  else if (YES == sel_eq(@selector(setLineCap:), operator))
    {
      [path_paint_style setLineCap: [paint_style lineCap]];
    }
  else if (YES == sel_eq(@selector(setMiterLimit:), operator))
    {
      [path_paint_style setMiterLimit: [paint_style miterLimit]];
    }
  else if (YES == sel_eq(@selector(setLineWidth:), operator))
    {
      [path_paint_style setLineWidth: [paint_style lineWidth]];
    }
  else if (YES == sel_eq(@selector(setStroking:), operator))
    {
      [path_paint_style setStroking: [paint_style stroking]];
    }
  else if (YES == sel_eq(@selector(setFilling:), operator))
    {
      [path_paint_style setFilling: [paint_style filling]];
    }
  return visitor_continue;
}
- (enum gyve_visitor_request)visitAtBuffer:(GyveBuffer *)buffer
{
  return visitor_detail;
}
- (enum gyve_visitor_request)visitAtLayer:(GyveLayer *)layer
{
   return visitor_detail;
}
- (enum gyve_visitor_request)visitAtText:(NSObject<PSText>*)text
{
  PSPaintStyle * text_paint_style;
  text_paint_style = [[text firstTextElement] paintStyle];
  
  if (YES == sel_eq(operator, @selector(installPaintStyle:)))
    {
      [text_paint_style installPaintStyle: paint_style];
    }
  else if (YES == sel_eq(@selector(setLineJoin:), operator))
    {
      [text_paint_style setLineJoin: [paint_style lineJoin]];
    }
  else if (YES == sel_eq(@selector(setLineCap:), operator))
    {
      [text_paint_style setLineCap: [paint_style lineCap]];
    }
  else if (YES == sel_eq(@selector(setMiterLimit:), operator))
    {
      [text_paint_style setMiterLimit: [paint_style miterLimit]];
    }
  else if (YES == sel_eq(@selector(setLineWidth:), operator))
    {
      [text_paint_style setLineWidth: [paint_style lineWidth]];
    }
  else if (YES == sel_eq(@selector(setStroking:), operator))
    {
      [text_paint_style setStroking: [paint_style stroking]];
    }
  else if (YES == sel_eq(@selector(setFilling:), operator))
    {
      [text_paint_style setFilling: [paint_style filling]];
    }
  return visitor_continue;
}
- (enum gyve_visitor_request)visitAtImage:(PSImage *)image
{
  return visitor_continue;
}
- (enum gyve_visitor_request)visitAtFigObjGroup:(PSFigObjGroup *)group
{
  return visitor_detail;
}
- (enum gyve_visitor_request)visitAtMaskedFigObjGroup:(PSMaskedFigObjGroup *)masked_group
{
  return visitor_detail;
}
- (enum gyve_visitor_request)visitAtCompoundPaths: (PSCompoundPaths *)compound_paths
{
  return visitor_detail;
}
- (enum gyve_visitor_request)visitAtProxy: (PSFigObjSelectedProxy *)proxy
{
  return visitor_detail;
}
- (void)leaveFromProxy: (PSFigObjSelectedProxy *)proxy {}
- (void)leaveFromBuffer:(GyveBuffer *)buffer {}
- (void)leaveFromLayer:(GyveLayer *)layer {}
- (void)leaveFromPath:(PSPath *)path {}
- (void)leaveFromText:(NSObject<PSText>*)text {}
- (void)leaveFromImage:(PSImage *)image {}
- (void)leaveFromFigObjGroup:(PSFigObjGroup *)group {}
- (void)leaveFromMaskedFigObjGroup:(PSMaskedFigObjGroup *)masked_group {}
- (void)leaveFromCompoundPaths: (PSCompoundPaths *)compound_paths {}
@end
