/* PSPath.h --- The definition for paths

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_PATH_H
#define P_S_PATH_H 

#include <gyve/constant.h>
#include <gyve/geometry.h>
#include <gyve/PSBBox.h>
#include <gyve/PSFigObj.h>
#include <gyve/utilities.h>
#include <gyve/containing.h>
#include <gyve/enumerating.h>

#include <Foundation/NSGeometry.h>

#include <Foundation/NSArray.h>

@class PSSegment, PSPaintStyle;

@protocol PSPath<PSFigObj, PointsContaining, SegmentsContaining>
- (BOOL)isClosedPath;
- (void)closePath;
- (void)openPath;
- (int)countPoints;
- (int)countSegments;
- (PSPaintStyle *)paintStyle;
- (void)setPaintStyle: (PSPaintStyle *) style;
@end

@interface PSPath: GyveArray<PSPath>
{
  struct bbox bbox;

  BOOL closed;
  /* ԽԲ */
  BOOL locked;
  /* ѥ 
     Ȥ. 
     -reverseOrderž뤳ȤǤ */
  BOOL order;
  BOOL selected;

  PSPaintStyle * paint_style;
}
// Constructing and destroying
+ (PSPath *)rectPathFromRect: (NSRect *)rect;
+ (PSPath *)roundRectPathFromRect: (NSRect *)rect
		    withRoundSeed: (float)roundseed;
+ (PSPath *)ovalPathFromRect: (NSRect *)rect;
- initWithMovetoPoint: (const NSPoint *)point;
- copyWithZone: (NSZone *)zone;
- (void)addLinetoPoint:  (const NSPoint *)point;
- (void)addCurvetoPoints: (const NSPoint *)points;
- (void)dealloc;

// Modification
- (PSSegment *)curveSegmentAtIndex: (int) i;

// Properties
- (PSPaintStyle *)paintStyle;
- (void)setPaintStyle: (BYREF PSPaintStyle *) style;
- (BOOL)isClosedPath;
- (void)closePath;
- (void)openPath;
- (BOOL)isLockedFigObj;
- (void)setFigObjLock: (BOOL)l;
- (void)reverseOrder;
- (BOOL)isRversed;

// Selection
- markAsSelected;
- (BOOL)isSelected;
- (void)unMarkAsSelected;

// BBox
- (void)calcBBox;
- (struct bbox *)bboxCStructure;
- (void)zeroBBox;		
- (BOOL)isZeroBBox;
- (BOOL)expandBBoxByBBox:(id<PSBBox>)b;
- (void)reportBBoxTo: (id<PSBBox>)b ;
@end

#endif /* Not def: P_S_PATH_H */
