/* PSPattern.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 


#ifndef P_S_PATTERN_H
#define P_S_PATTERN_H 

#include <gyve/constant.h>
#include <gyve/utilities.h>
#include <gyve/geometry.h>
#include <gyve/PSColor.h>
#include <gyve/PSProcessColor.h>
#include <gyve/dps.h>
#include <gyve/PSBBox.h>
#include <gyve/PSMatrix.h>

@interface PSPattern: GyveArray<PSUserObject, PSBBox>
{
  PSProcessColor * background_color;
  struct bbox background_bbox;
  userobject key;
}
- initWithBackgroundBBox:(BYCOPY NSObject<PSBBox>*)b ;
- (void)dealloc;
- (PSProcessColor *)backgroundColor;
- (void)setBackgroundColor:(BYCOPY NSObject <PSColor> *)c;
- (void)bindToUserobject: (userobject)i inContext:(DPSContext)ctxt;
- (userobject)userobject;
@end

@interface PSPatternOption: PSMatrix<NSCopying>
{
  NSString * name;
}
+ (PSPatternOption *)patternOptionWithName: (BYCOPY NSString *)_name;
- initWithName: (BYCOPY NSString *)_name;
- copyWithZone: (NSZone *)zone;
- (void)dealloc;
- (NSString *)patternName;
@end

@protocol PSPatternDictionary
- (void)setPattern: (BYREF PSPattern *) color forName: (BYREF NSString *)name;
- (PSPattern *)patternForName: (NSString *)name;
- (PSPattern *)patternForPatternOption: (PSPatternOption *)opt;
@end

@interface NSMutableDictionary(PSPatternDictionary)
- (void)setPattern: (BYREF PSPattern *) pattern forName: (BYREF NSString *)name;
- (PSPattern *)patternForName: (NSString *)name;
- (PSPattern *)patternForPatternOption: (PSPatternOption *)opt;
@end

@interface PSPatternDictionary: NSMutableDictionary<PSPatternDictionary>
- (void)setPattern: (BYREF PSPattern *) pattern forName: (BYREF NSString *)name;
- (PSPattern *)patternForName: (NSString *)name;
- (PSPattern *)patternForPatternOption: (PSPatternOption *)opt;
@end

#endif /* Not def: P_S_PATTERN_H */
