/* PSPattern.m --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSPattern.h"
#include "dps.h"
#include "geometry.h"
#include "pattern.h"
#include <DPS/dpsclient.h>

@implementation PSPattern
- initWithBackgroundBBox:(BYCOPY NSObject<PSBBox>*)b 
{
  [super init];
  bbox_copy([b bboxCStructure], &background_bbox);
  background_color = nil;
  [self setBackgroundColor: [PSProcessColor processColorWithRed: 1.0
				     green: 1.0
				     blue: 1.0]];
  key = userobject_unbound;
  return self; 
}
- (void)dealloc
{
  DESTROY(background_color);
  background_bbox = zero_bbox;
  key = userobject_unbound;
  [super dealloc];
}
- (PSProcessColor *)backgroundColor
{
  return background_color;
}
- (void)setBackgroundColor:(BYCOPY NSObject <PSColor> *)c
{
  PSProcessColor * pc = [PSProcessColor processColorWithRed: [c red]
					green: [c green]
					blue: [c blue]];
  ASSIGN(background_color, pc);
}
- (void)bindToUserobject: (userobject)i inContext:(DPSContext)ctxt
{
  key = i;
  DPSPrintf(ctxt, "<< /PaintType 1 /PatternType 1 /TilingType 1\n");
  DPSPrintf(ctxt, "/BBox [%f %f %f %f]\n",
	    bbox_element(&background_bbox, BBOX_LLX), 
	    bbox_element(&background_bbox, BBOX_LLY),
	    bbox_element(&background_bbox, BBOX_URX), 
	    bbox_element(&background_bbox, BBOX_URY));
  DPSPrintf(ctxt, "/XStep %f /YStep %f\n", 
	    bbox_element(&background_bbox, BBOX_URX)  
	    - bbox_element(&background_bbox, BBOX_LLX),
	    bbox_element(&background_bbox, BBOX_URX) 
	    - bbox_element(&background_bbox, BBOX_LLY));
  DPSPrintf(ctxt, "/PaintProc { begin\n");
  {
    DPSPrintf(ctxt, 
	      "%f %f moveto\n" 
	      "%f %f lineto\n"
	      "%f %f lineto\n"
	      "%f %f lineto\n"
	      "closepath\n",
	      bbox_element(&background_bbox, BBOX_LLX), 
	      bbox_element(&background_bbox, BBOX_LLY),
	      bbox_element(&background_bbox, BBOX_LLX), 
	      bbox_element(&background_bbox, BBOX_URX),
	      bbox_element(&background_bbox, BBOX_URX), 
	      bbox_element(&background_bbox, BBOX_URX),
	      bbox_element(&background_bbox, BBOX_URX), 
	      bbox_element(&background_bbox, BBOX_LLY));
    DPSPrintf(ctxt, "%f %f %f setrgbcolor\n",
	      [background_color red], 
	      [background_color green], 
	      [background_color blue]);
    DPSPrintf(ctxt, "fill\n");
  }
  /*
   * TODO: 
   */
  DPSPrintf(ctxt, "end } >>\n");
  psw_define_user_pattern(ctxt, key); 
}
- (userobject)userobject
{
  return key;
}
- (void)calcBBox {}
- (struct bbox *)bboxCStructure
{
  return &background_bbox;
}
- (void)zeroBBox
{
  bbox_copy(&zero_bbox, [self bboxCStructure]);
}
- (BOOL)isZeroBBox
{
  return bbox_is_zero_bbox([self bboxCStructure]);
}
- (BOOL)expandBBoxByBBox: (id<PSBBox>)b
{
  return bbox_expand_by_bbox([self bboxCStructure], [b bboxCStructure]);
}
- (void)reportBBoxTo: (id<PSBBox>)b
{
  [b expandBBoxByBBox: self];
}
- (BOOL)isPointInBBox: (NSPoint *)p
{
  return bbox_contains_point([self bboxCStructure], p);
}
- (BOOL)intersectsWithBBox: (id<PSBBox>)b
{
  return bbox_intersects([self bboxCStructure], [b bboxCStructure]);
}
- (BOOL)intersectsWithRect: (NSRect *)r
{
  struct bbox b;
  NSRect_to_bbox (r, &b);
  return bbox_intersects([self bboxCStructure], &b);
}
@end

@implementation PSPatternOption
+ (PSPatternOption *)patternOptionWithName: (BYCOPY NSString *)_name
{
  return [[[self alloc] initWithName: _name] autorelease];
}
- initWithName: (BYCOPY NSString *)_name
{
  [super init];
  name = [_name copy];
  return self ;
}
- copyWithZone: (NSZone *)zone
{
  PSPatternOption * opt = [[[self class] alloc] initWithName: [self patternName]];
  [opt setMatrix: self ofType: OBJC_MATRIX];
  return opt;
}
- (void)dealloc
{
  DESTROY(name);
  [super dealloc];
}
- (NSString *)patternName
{
  return name;
}
@end

@implementation  NSMutableDictionary(PSPatternDictionary)
- (void)setPattern: (BYREF PSPattern *) pattern forName: (BYREF NSString *)name
{
  [self setObject: pattern forKey: name];
  userobject_new(pattern);
}
- (PSPattern *)patternForName: (NSString *)name
{
  return (PSPattern *)[self objectForKey: name];
}
- (PSPattern *)patternForPatternOption: (PSPatternOption *)opt
{
  return [self patternForName: [opt patternName]];
}
@end

@implementation  PSPatternDictionary
- (void)setPattern: (BYREF PSPattern *) pattern forName: (BYREF NSString *)name
{
  [super setPattern: pattern forName: name];
}
- (PSPattern *)patternForName: (NSString *)name
{
  return [super patternForName: name];
}
- (PSPattern *)patternForPatternOption: (PSPatternOption *)opt
{
  return [super patternForPatternOption: opt];
}
@end
