/* PSProcessColor.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_PROCESS_COLOR_H
#define P_S_PROCESS_COLOR_H 

#include <gyve/PSColor.h>
#include <Foundation/NSObject.h>

@interface PSProcessColor: NSObject<PSColor, NSCopying>
{
  struct color color;
}
+ (PSProcessColor *)processColorWithRed: (float)r green: (float)g blue: (float)b;
- init;
- initWithRed: (float)r green: (float)g blue: (float)b;
- copyWithZone: (NSZone *)zone;
- (void) dealloc;
- (float)red;
- (float)green;
- (float)blue;
- (void)setRed: (float)r;
- (void)setGreen: (float)g;
- (void)setBlue: (float)b;
@end

#endif /* Not def: P_S_PROCESS_COLOR_H */
