/* PSProcessColor.m --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSProcessColor.h"
#include <stdio.h>
@implementation PSProcessColor
+ (PSProcessColor *)processColorWithRed: (float)r green: (float)g blue: (float)b
{
  return [[[self alloc] initWithRed: r green: g blue: b] autorelease];
}
- init
{
  [super init];
  color_init_as_white(&color);
  return self ;
}
- initWithRed: (float)r green: (float)g blue: (float)b
{
  [super init];
  color.red = r;
  color.green = g;
  color.blue = b;
  return self ;
}
- (void) dealloc
{
  [super dealloc];
}
- copyWithZone: (NSZone *)zone
{
  return [[[self class] allocWithZone: zone] 
	   initWithRed: [self red]
	   green: [self green]
	   blue: [self blue]];
}
- (float)red 
{ 
  return color.red;
}
- (float)green
{
  return color.green;
}
- (float)blue
{
  return color.blue;
}
- (void)setRed: (float)r
{
  color.red = r;
}
- (void)setGreen: (float)g
{
  color.green = g;
}
- (void)setBlue: (float)b
{
  color.blue = b;
}
@end
