/* PSSegment.h --- The segment definition for paths

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_SEGMENT_H
#define P_S_SEGMENT_H 

#include <gyve/constant.h>
#include <gyve/containing.h>
#include <Foundation/NSGeometry.h>
#include <DPS/dpsfriends.h>
#include <DPS/dpsXuserpath.h>   
/* Path륻Ȥˤ, moveto, lineto, curveto. 
  movetolinetoϰĤκɸcurveto3Ĥκɸ򥻥
  ɬפǤ. 
  
  C, ObjCΥץεҤǤ, moveto, lineto, curveto
  줾DPSUserPathOp dps_moveto, dps_lineto, dps_curveto
  Ѥƻꤹ. 
  
  <DPS/dpsXuserpath.h>ˤ. */

/* ؿcount_points_from_path_opopǻꤵ줿Ȥμ
   Ф, ΥȤμबɸο֤. 
   δؿPS_SEGMENT_WRONG_PATH_OP֤Ȥ, opǤ. */
#define PS_SEGMENT_WRONG_PATH_OP -1
int count_points_from_path_op(DPSUserPathOp op);

/* 㳰, [PSSegment -initWithDPSOperation:points:]
    ڥ졼ͿǤ. */
@class NSString;
extern NSString * PSSegmentWrongOpException;

@interface PSSegment: NSObject<PointsContaining>
{
  DPSUserPathOp op;
  NSPoint * points;
}
/* ȤμoPSSegment. 
   ݥc𤷤oɬפȤɸοǡ򻲾Ȥ. 

   ⤷, oǤ, PSSegmentWrongOpExceptionꤲ. */
- initWithDPSOperation: (DPSUserPathOp)o points: (const NSPoint *)p;
- copyWithZone:(NSZone *)zone;
- (void) dealloc;

/* 󥹥󥹤ΥȤμ */
- (DPSUserPathOp)dpsOperation;

/* 󥹥󥹤ΥȤȤɸο */
- (int) countPoints;

/* indexܤκɸꤹ. 
   ⤷index礭NSRangeExceptionꤲ.  */
- (void)setPoint: (NSPoint*)p atIndex:(int)index;

/* indexܤκɸ껲Ȥ. 
   ⤷index礭NSRangeExceptionꤲ.  */
- (NSPoint *) pointAtIndex:(int)index;
- (int)indexOfPoint: (NSPoint *)p;
- (NSPointValue *) pointValueAtIndex:(int)index;
- (NSPoint *) firstPoint;
- (NSPoint *) lastPoint;
- (NSPointValue *)firstPointValue;
- (NSPointValue *)lastPointValue;
- (id<PointsEnumerating>)reversePointsEnumerator;
@end

@class NSPointValue;
@interface PSSegment(Guile)
- (NSPointValue *) pointValueAtIndex:(int)index;
+ (DPSUserPathOp)movetoDPSOperation;
+ (DPSUserPathOp)linetoDPSOperation;
+ (DPSUserPathOp)curvetoDPSOperation;
@end
#endif /* Not def: P_S_SEGMENT_H */
