/* PSText.h --- The definition for text 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_TEXT_H
#define P_S_TEXT_H 

#include <Foundation/NSGeometry.h>
#include <Foundation/NSObject.h>

#include <gyve/GyveSelectionsLayer.h>
#include <gyve/PSFigObj.h>
#include <gyve/PSBBox.h>
#include <gyve/geometry.h>
#include <gyve/utilities.h>

@class PSTextElement;

@protocol PSText<PSFigObj>
- (int)countTextElements;
- (PSTextElement *)firstTextElement;
- (PSTextElement *)lastTextElement;
- (PSTextElement *)textElementAtIndex: (int)n;
- (int)indexOfTextElement: (BYREF PSTextElement *)e;

// Adding and inserting
- (void)addTextElement: (BYREF PSTextElement *)e;
- (void)insertTextElement: (BYREF PSTextElement *)e atIndex: (int)n;
- (void)insertString: (BYCOPY NSString *)str atIndex: (int)n;

// Removing
- (void)removeLastTextElement;
- (void)removeTextElementAtIndex: (int)n;
- (void)removeTextElementsInRange: (NSRange *)range;

- (BOOL)hasZeroBBoxTextElement;

// 
- (NSString*) string;
- (NSString*)substringFromRange: (NSRange)range;
@end

@interface PSTextSelectedProxy: PSFigObjSelectedProxy
{
  BOOL has_insertion_index;
  NSRange selected_range;
}
- (id<PSText>)targetForTextProxy;
- (void)setInsertionIndex:(int)i;
- (void)setSelectionRange:(BYCOPY NSRange *)r;

// 
- (void)removeTextElements;
- (void)insertString: (BYCOPY NSString *)str;
- (void)insertTextElement: (BYREF PSTextElement *)e;
- (NSString*)substring;

/* SelectionRangeInsertionIndex˽व.  */
- (void)clearSelectionRange;
- (void)clearInsertionIndex;

- (NSRange *)selectionRange;
- (int)selectionLength;		// if there is no index, return -1
- (int)selectionLocation;	// if there is no index, return -1
- (int)insertionIndex;
- (BOOL)hasSelectionRange;
- (BOOL)hasInsertionIndex;
- (BOOL)isIndexInSelectionRange: (int)n;
- (BOOL)isTextElementInSelectionRange: (PSTextElement *)e;
@end

@interface  PSTextSelectedProxy(PSText)<PSText>
/* PSText */
- (int)countTextElements;
- (PSTextElement *)firstTextElement;
- (PSTextElement *)lastTextElement;
- (PSTextElement *)textElementAtIndex: (int)n;
- (int)indexOfTextElement: (BYREF PSTextElement *)e;

// Adding and inserting
- (void)addTextElement: (BYREF PSTextElement *)e;
- (void)insertTextElement: (BYREF PSTextElement *)e atIndex: (int)n;
- (void)insertString: (BYCOPY NSString *)str atIndex: (int)n;

// Removing
- (void)removeLastTextElement;
- (void)removeTextElementAtIndex: (int)n;
- (void)removeTextElementsInRange: (NSRange *)range;

- (BOOL)hasZeroBBoxTextElement;

// 
- (NSString*)string;
- (NSString*)substringFromRange: (NSRange)range;
@end

@interface PSTextAtPoint: GyveArray<PSText>
{
  float mapping_matrix[6];
  BOOL selected;
  BOOL lock;
  struct bbox bbox;
}
- initWithString: (NSString *)str point: (BYCOPY const NSPoint *)p;
- initWithString: (NSString *)str pointValue: (BYCOPY NSPointValue *)p;
- initWithPoint: (const NSPoint *)p;
- initWithPointValue: (NSPointValue *)p;
- (const char*) cString;
- (NSString*) string;

// PSText
- (int)countTextElements;
- (PSTextElement *)textElementAtIndex: (int)n;
- (void)addTextElement: (PSTextElement *)e;
- (int)indexOfTextElement: (BYREF PSTextElement *)e;
- (float *)mappingMatrix;
- (void)setMappingMatrix: (float *)new_mapping_matrix;
- (BOOL)hasZeroBBoxTextElement;
- (PSTextElement *)firstTextElement;
- (PSTextElement *)lastTextElement;

// FigObj
- (BOOL)isLockedFigObj;
- (void)setFigObjLock: (BOOL)l;

// BBox
- (void)calcBBox;
- (struct bbox *)bboxCStructure;
- (void)zeroBBox;
- (BOOL)isZeroBBox;
- (BOOL)expandBBoxByBBox:(id<PSBBox>)b;
- (void)reportBBoxTo: (id<PSBBox>)b;
- (BOOL)isPointInBBox: (NSPoint *)p;
- (BOOL)intersectsWithBBox: (id<PSBBox>)b;
@end

/*
@interface PSTextOnPath:  GyveArray<PSText>
@end

@interface PSTextInPath:  GyveArray<PSText>
@end */


#endif /* Not def: P_S_TEXT_H */
