/* PSTextElement.h --- The definition for text element
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_TEXT_ELEMENT_H
#define P_S_TEXT_ELEMENT_H 
#include <gyve/PSPaintStyle.h>
#include <gyve/PSTextStyle.h>
#include <gyve/PSBBox.h>
#include <gyve/geometry.h>
#include <Foundation/NSObject.h>


@interface PSTextElement: NSObject <NSCopying, PSBBox>
{
  int character;
  struct bbox bbox;
  PSTextStyle * text_style;
  PSPaintStyle * paint_style;
}
+ textElementWithCharacter: (int)c;

- initWithCharacter: (int)c;
- (BOOL)isNewLine;
- (BOOL)isSpace;
- (void)setTextStyle: (BYCOPY id<PSTextStyle>)style;
- (id<PSTextStyle>)textStyle;

- (void)setPaintStyle: (BYCOPY id<PSPaintStyle>)style;
- (id<PSPaintStyle>)paintStyle;

- (void)setCharacter: (int)c;
- (int)character;

// BBox
- (void)calcBBox; 
- (struct bbox *)bboxCStructure;
- (void)zeroBBox;
- (BOOL)isZeroBBox;
- (BOOL)expandBBoxByBBox: (id<PSBBox>)b;
- (void)reportBBoxTo: (id<PSBBox>)b ;
- (BOOL)isPointInBBox: (NSPoint *)p;
- (BOOL)intersectsWithBBox: (id<PSBBox>)b;
- (BOOL)intersectsWithRect: (NSRect *)r;

@end

#endif /* Not def: P_S_TEXT_ELEMENT_H */
