/* PSTextElement.m --- The definition for text element
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSTextElement.h"

@implementation PSTextElement
+ textElementWithCharacter: (int)c
{
  return [[[self alloc] initWithCharacter: c] autorelease];
}
- initWithCharacter: (int)c
{
  [super init];
  text_style  	= nil;
  paint_style 	= nil;
  bbox 		= zero_bbox;
  [self setCharacter: c];
  return self ;
}
- (void)dealloc
{
  if (text_style) [text_style release], text_style = nil;
  if (paint_style) [paint_style release], paint_style = nil;
  [super dealloc];
}
- (id<PSTextStyle>)textStyle
{
  return text_style;
}
- (void)setTextStyle: (BYCOPY id<PSTextStyle>)style
{
  if (nil == style)
    {
      if (text_style)
	{
	  [text_style release], text_style = nil;
	}
    }
  else if (nil == text_style)
    {
      text_style = [[PSTextStyle alloc] initWithTextStyle: style];
    }
  else
    {
      [text_style installTextStyle: style];
    }
}
- (id<PSPaintStyle>)paintStyle
{
  return paint_style;
}
- (void)setPaintStyle: (id<PSPaintStyle>)style
{
 if (nil == style)
    {
      if (paint_style)
	{
	  [paint_style release], paint_style = nil;
	}
    }
  else if (nil == paint_style)
    {
      paint_style = [[PSPaintStyle alloc] initWithPaintStyle: style];
    }
  else
    {
      [paint_style installPaintStyle: style];
    }
}
- (void)setCharacter: (int)c
{
  character = c;
}
- (int)character
{
  return character;
}
- copyWithZone: (NSZone *)zone
{
  PSTextElement * copy_element = [[[self class] allocWithZone: zone]
				   initWithCharacter: [self character]];
  if (nil != [self textStyle])
    [copy_element setTextStyle: [self textStyle]];
  if (nil != [self paintStyle])
    [copy_element setPaintStyle: [self paintStyle]];

  // TODO ٤ƤΥ󥹥ѿ򥳥ԡ뤳
  bbox_copy([self bboxCStructure], [copy_element bboxCStructure]);
  return copy_element;
}
- (void)calcBBox
{
  [self shouldNotImplement:_cmd];
}
- (struct bbox *)bboxCStructure
{
  return &bbox;
}
- (void)zeroBBox
{
  bbox = zero_bbox;
}
- (BOOL)isZeroBBox
{
  return bbox_is_zero_bbox([self bboxCStructure]);
}
- (BOOL)expandBBoxByBBox: (id<PSBBox>)b
{
  if (YES == [self isZeroBBox])
    return NO;
  else
    return bbox_expand_by_bbox([self bboxCStructure], [b bboxCStructure]);
}
- (void)reportBBoxTo: (id<PSBBox>)b
{
  if (NO == [self isZeroBBox])
    [b expandBBoxByBBox: self];
}
- (BOOL)isPointInBBox: (NSPoint *)p
{
  if (NO == [self isZeroBBox])
    return bbox_contains_point([self bboxCStructure], p);
  else 
    return NO;
}
- (BOOL)intersectsWithBBox: (id<PSBBox>)b
{
  if (NO == [self isZeroBBox])
    return bbox_intersects([self bboxCStructure], [b bboxCStructure]);
  else
    return NO;
}
- (BOOL)intersectsWithRect: (NSRect *)r
{
  if (NO == [self isZeroBBox])
    {
      struct bbox b;
      NSRect_to_bbox (r, &b);
      return bbox_intersects([self bboxCStructure], &b);
    } 
  else
    return NO;  
}
- (BOOL)isNewLine
{
  if (character == '\n')
    return YES;
  else
    return NO;
}
- (BOOL)isSpace
{
  if (character == ' ')
    return YES;
  else
    return NO;
}
@end
