/* PSTextStyle.h --- 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_TEXT_STYLE_H
#define P_S_TEXT_STYLE_H 
#include <Foundation/NSObject.h>
#include <gyve/utilities.h>

@class NSString;

@protocol PSTextStyle
- (void)installTextStyle: (id<PSTextStyle>)base_style;
- (void)setFontName: (bycopy NSString *)name;
- (NSString *)fontName;
- (void)setFontSize: (float)s;
- (float)fontSize;
@end

@interface PSTextStyle: NSObject<NSCopying, PSTextStyle>
{
  NSString * font_name;
  float font_size;
  // baseline, linefeed, tracking...very difficult...
}
- initWithFontName: (NSString *)fn size:(float)s;
- initWithTextStyle: (BYCOPY id<PSTextStyle>)base_style;
- (void)installTextStyle: (BYCOPY id<PSTextStyle>)base_style;
- (void)setFontName: (BYCOPY NSString *)name;
- (void)setFontSize: (float)s;
- (NSString *)fontName;
- (float)fontSize;
- (void)dealloc;
@end

#endif /* Not def: P_S_TEXT_STYLE_H */
