/* PSTextStyle.m --- 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSTextStyle.h"
#include <Foundation/NSString.h>

@implementation  PSTextStyle
- initWithFontName: (NSString *)fn size:(float)s
{
  [super init];
  font_name = [fn copy];
  font_size 	   = s;
  return self ;
}
- initWithTextStyle: (BYCOPY id<PSTextStyle>)base_style
{
  [super init];
  font_name = nil;
  [self installTextStyle: base_style];
  return self ;
}
- (void)installTextStyle: (id<PSTextStyle>)base_style
{
  if (base_style    == self 
      || base_style == nil)
    {
      return;
    }
  [self setFontName: [base_style fontName]];
  [self setFontSize: [base_style fontSize]];
}
- (void)setFontName: (BYCOPY NSString *)name
{
  if ((nil != name ) && (name != font_name))
    {
      [font_name release];
      font_name = [name copy];
    }
}
- (NSString *)fontName
{
  return font_name;
}
- (float)fontSize
{
  return font_size;
}
- (void)setFontSize: (float)s
{
  font_size = s;
}
- copyWithZone: (NSZone *)zone
{
  return [[[self class] alloc]
	   initWithFontName: [self fontName] size: [self fontSize]];
}

- (void)dealloc
{
  [font_name release];
  [super dealloc];
}
@end
