/* PaintStylePallet.h --- 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_PAINT_STYLE_PALLET_H
#define GYVE_PAINT_STYLE_PALLET_H 
#include <gyve/PSPaintStyle.h>
#include <gyve/GyveGUI.h>
#include <gyve/PSCustomColor.h>
#include <gyve/PSPattern.h>
#include <gtk/gtkwidget.h>
#include <gyve/painting_preview.h>

@interface PaintStylePallet: GyveGUI<PSPaintStyle, PSCustomColorDictionary>
{
  PSPaintStyle * paint_style;
  PSCustomColorDictionary * custom_colors_dict;
  PSPatternDictionary * patterns_dict;
@public
  GtkWidget * joins_button[3];
  GtkWidget * caps_button[3];
  GtkObject  *linewidth_adjutment;
  struct painting_preview preview_data;

  GtkWidget * process_color_pallet;

  GtkWidget * custom_colors_list_box;
  struct CColor
  {
    struct CColor *next;
    char *name;
    int position;
  } *first_ccolor;

  GtkWidget * patterns_list_box;
  GtkWidget * gradation_list_box;
}
+ (PaintStylePallet *)paintStylePallet;

- init;

// Cuttom Color Dict 
- (void)setColor: (BYCOPY PSProcessColor *) color forName: (BYCOPY NSString *)name;
- (PSProcessColor *)colorForName: (NSString *)name;
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color;

// PaintStyle
- (void)installPaintStyle: (PSPaintStyle *)base_style; 
- (void)setLineJoin: (enum ps_line_join)lj;
- (enum ps_line_join)lineJoin;
- (void)setLineCap: (enum ps_line_cap)lc;
- (enum ps_line_cap)lineCap;
- (void)setMiterLimit: (float)ml;
- (float)miterLimit;
- (void)setLineWidth:(float)width;
- (float)lineWidth;


- (void)setPainting: (BYCOPY NSObject<NSCopying>*)p;
- (DPSUserPathAction)activePreview;
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s;
- (NSObject<NSCopying>*)stroking;
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f;
- (NSObject<NSCopying>*)filling;
@end

void paint_style_pallet_show();
void paint_style_pallet_hide();
PaintStylePallet * paint_style_pallet();

#endif /* Not def: GYVE_PAINT_STYLE_PALLET_H */
