/* PaintStylePallet.m --- 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "GyveWindow.h"
#include "PaintStylePallet.h"
#include "paint_style_pallet.h"
#include "Gyve.h"
#include "GyveBuffer.h"

static NSString * rgb_txt_default_array[] = {
  @"/usr/openwin/lib/X11/rgb.txt",
  @"/usr/X11R6/lib/X11/rgb.txt", 
  @"/usr/local/X11R6/lib/X11/rgb.txt", // solaris2
  @"/usr/X11R6.1/lib/X11/rgb.txt", 
  @"/usr/local/X11R6.1/lib/X11/rgb.txt",
  @"/usr/X11R6.3/lib/X11/rgb.txt", 
  @"/usr/local/X11R6.3/lib/X11/rgb.txt",
  @"/usr/X11R5/lib/X11/rgb.txt", 
  @"/usr/local/X11R5/lib/X11/rgb.txt", 
  @"/usr/X11/lib/X11/rgb.txt", 
  @"/usr/local/X11/lib/X11/rgb.txt", 
  @"/usr/lib/X11/rgb.txt",	// osf1, irix
  nil
};
static FILE * rgb_open(NSString ** rgbfile);
static BOOL rgb_load(PaintStylePallet * pallet);

static PaintStylePallet * shared_paint_style_pallet = nil;

@implementation PaintStylePallet
+ (GyveGUI *)sharedObject
{
  if (nil == shared_paint_style_pallet)
    shared_paint_style_pallet = [[self alloc] init];
  return shared_paint_style_pallet;
}
+ (PaintStylePallet *)paintStylePallet
{
  return (PaintStylePallet *)[self sharedObject];
}
- init
{
  [super init];
  paint_style 	    = [[PSPaintStyle alloc] init];
  custom_colors_dict = [[PSCustomColorDictionary alloc] init];
  patterns_dict      = [[PSPatternDictionary alloc] init];
  first_ccolor 	    = NULL;
  widget 	    = paint_style_pallet_new(self);
  rgb_load(self);
  return self ;
}
- (void)dealloc
{
  DESTROY(paint_style);
  DESTROY(custom_colors_dict);
  DESTROY(patterns_dict);
  [super dealloc];
}
- (void)setStroking: (BYCOPY NSObject<NSCopying>*)s
{
  [paint_style setStroking: s];
  painting_preview_set_painting(&preview_data, s, dps_ustroke);
  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      int i, max;
      PSPaintStyleApplier * applier;
      GyveWindow * win = [GyveWindow lastClickedWindow];
      GyveBuffer * buf = [win contentBuffer];
      BOOL copied_by_me;

      [win redrawLockRetain];
      copied_by_me = [buf beginModificationByCopyOfAll];

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      applier = [[PSPaintStyleApplier alloc] 
		  initWithVisitingTarget: [buf selectionsLayer]];
      [applier setStroking: [self stroking]];
      [applier release], applier = nil;

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      if (YES == copied_by_me) [buf endModificationOfAll];
      [win redrawLockRelease];
    }
  else
    {
      if ([s isKindOfClass: [PSProcessColor class]])
	{
	  gdouble c[3];
	  c[0] = [(PSProcessColor*)s red];
	  c[1] = [(PSProcessColor*)s green];
	  c[2] = [(PSProcessColor*)s blue];
	  gtk_color_selection_set_color(GTK_COLOR_SELECTION(process_color_pallet),
					c);
	}
      else if ([s isKindOfClass: [PSCustomColor class]])
	{
	  // TODO
	}
    }
}
- (NSObject<NSCopying>*)stroking
{
  return [paint_style stroking];
}
- (void)setFilling: (BYCOPY NSObject<NSCopying>*)f
{
  [paint_style setFilling: f];
  painting_preview_set_painting(&preview_data, f, dps_ufill);
  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      int i, max;
      PSPaintStyleApplier * applier;
      GyveWindow * win = [GyveWindow lastClickedWindow];
      GyveBuffer * buf = [win contentBuffer];
      BOOL copied_by_me;

      [win redrawLockRetain];
      copied_by_me = [buf beginModificationByCopyOfAll];

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      applier = [[PSPaintStyleApplier alloc] 
		  initWithVisitingTarget: [buf selectionsLayer]];
      [applier setFilling: [self filling]];
      [applier release], applier = nil;

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      if (YES == copied_by_me) [buf endModificationOfAll];
      [win redrawLockRelease];
    }
  else
    {
      if ([f isKindOfClass: [PSProcessColor class]])
	{
	  gdouble c[3];
	  c[0] = [(PSProcessColor*)f red];
	  c[1] = [(PSProcessColor*)f green];
	  c[2] = [(PSProcessColor*)f blue];
	  gtk_color_selection_set_color(GTK_COLOR_SELECTION(process_color_pallet),
					c);
	}
      else if ([f isKindOfClass: [PSCustomColor class]])
	{
	  // TODO
	}
    }
}
- (NSObject<NSCopying>*)filling
{
  return [paint_style filling];
}
- (void)setColor: (BYCOPY PSProcessColor *) color forName: (BYCOPY NSString *)name
{
  struct CColor * tmp;
  GtkWidget *list_item;

  [custom_colors_dict setColor: color forName: name];
  if (!first_ccolor)
    {
      first_ccolor = (struct CColor *) g_malloc (sizeof (struct CColor));
      first_ccolor->name = (char *) g_malloc ([name length] + 1);
      strcpy (first_ccolor->name, [name cString]);
      first_ccolor->next = NULL;
      tmp = first_ccolor;
    }
  else
    {
      tmp = (struct CColor *) g_malloc (sizeof (struct CColor));
      tmp->name = (char *) g_malloc ([name length] + 1);
      strcpy (tmp->name, [name cString]);
      tmp->next = NULL;
    }
  list_item = gtk_list_item_new_with_label (tmp->name);
  gtk_container_add (GTK_CONTAINER (custom_colors_list_box), list_item);
  gtk_object_set_user_data (GTK_OBJECT (list_item), tmp->name);
  gtk_widget_show (list_item);
  tmp->position = gtk_list_child_position (GTK_LIST (custom_colors_list_box), 
					   list_item);  
  tmp = tmp->next;		// ???
}
- (PSProcessColor *)colorForName: (NSString *)name
{
  return [custom_colors_dict colorForName: name];
}
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color
{
  return [custom_colors_dict colorForCustomColor: custom_color];
}
- (void)installPaintStyle: (PSPaintStyle *)base_style
{
  BOOL copied_by_me;
  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      GyveWindow * window = [GyveWindow lastClickedWindow];
      [window redrawLockRetain];
      copied_by_me = [[window contentBuffer] beginModificationByCopyOfAll];
    }
  [self setLineJoin: [base_style lineJoin]];
  [self setLineCap: [base_style lineCap]];
  [self setMiterLimit: [base_style miterLimit]];
  [self setLineWidth: [base_style lineWidth]];
  [self setStroking:  [base_style stroking]];
  [self setFilling:  [base_style filling]];
  painting_preview_update(&preview_data);
  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      GyveWindow * window = [GyveWindow lastClickedWindow];
      if (YES == copied_by_me) [[window contentBuffer] endModificationOfAll];
      [window redrawLockRelease];
    }
}
- (void)setLineJoin: (enum ps_line_join)lj
{
  [paint_style setLineJoin: lj];
  painting_preview_update(&preview_data);
  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      int i, max;
      PSPaintStyleApplier * applier;
      GyveWindow * win = [GyveWindow lastClickedWindow];
      GyveBuffer * buf = [win contentBuffer];
      BOOL copied_by_me;

      [win redrawLockRetain];
      copied_by_me = [buf beginModificationByCopyOfAll];

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      applier = [[PSPaintStyleApplier alloc] 
		  initWithVisitingTarget: [buf selectionsLayer]];
      [applier setLineJoin: [self lineJoin]];
      [applier release], applier = nil;

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      if (YES == copied_by_me) [buf endModificationOfAll];
      [win redrawLockRelease];
    }
  else
    {
      int button_index;
      for (button_index = 0; button_index < 3; button_index++)
	{
	  if (lj == button_index)
	    gtk_toggle_button_set_state (
	      GTK_TOGGLE_BUTTON (joins_button[button_index]), TRUE);
	  else
	    gtk_toggle_button_set_state (
	      GTK_TOGGLE_BUTTON (joins_button[button_index]), FALSE);
	}
    }
}
- (enum ps_line_join)lineJoin
{
  return [paint_style lineJoin];
}
- (void)setLineCap: (enum ps_line_cap)lc
{
  [paint_style setLineCap: lc];
  painting_preview_update(&preview_data);
  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      int i, max;
      PSPaintStyleApplier * applier;
      GyveWindow * win = [GyveWindow lastClickedWindow];
      GyveBuffer * buf = [win contentBuffer];
      BOOL copied_by_me;

      [win redrawLockRetain];
      copied_by_me = [buf beginModificationByCopyOfAll];

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      applier = [[PSPaintStyleApplier alloc] 
		  initWithVisitingTarget: [buf selectionsLayer]];
      [applier setLineCap: [self lineCap]];
      [applier release], applier = nil;

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      if (YES == copied_by_me) [buf endModificationOfAll];
      [win redrawLockRelease];
    }
  else
    {
      int button_index;
      for (button_index = 0; button_index < 3; button_index++)
	{
	  if (lc == button_index)
	    gtk_toggle_button_set_state (
	      GTK_TOGGLE_BUTTON (caps_button[button_index]), 
	      TRUE);
	  else
	    gtk_toggle_button_set_state (
	      GTK_TOGGLE_BUTTON (caps_button[button_index]),
	      FALSE);
	}
    }
}
- (enum ps_line_cap)lineCap
{
  return [paint_style lineCap];
}
- (void)setMiterLimit: (float)ml
{
  [paint_style setMiterLimit: ml];
}
- (float)miterLimit
{
  return [paint_style miterLimit];
}
- (void)setLineWidth:(float)width
{
  [paint_style setLineWidth: width];
  painting_preview_update(&preview_data);

  if ([[Gyve application] mode] == GUI_interactive_mode)
    {
      PSPaintStyleApplier * applier;
      GyveWindow * win = [GyveWindow lastClickedWindow];
      GyveBuffer * buf = [win contentBuffer];
      int i, max;
      BOOL copied_by_me;

      [win redrawLockRetain];
      copied_by_me = [buf beginModificationByCopyOfAll];

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      applier = [[PSPaintStyleApplier alloc] 
		  initWithVisitingTarget: [buf selectionsLayer]];
      [applier setLineWidth: [self lineWidth]];
      [applier release], applier = nil;

      max = [buf countSelectedFigObjs];
      for (i = 0; i < max; i++)
	[win redrawFigObj: [buf selectedFigObjAtIndex:  i]];

      if (YES == copied_by_me) [buf endModificationOfAll];
      [win redrawLockRelease];
    }
  else
    {
      gtk_adjustment_set_value(GTK_ADJUSTMENT(linewidth_adjutment), width);
    }
}
- (float)lineWidth
{
  return [paint_style lineWidth];
}
- (void)setPainting: (BYCOPY NSObject<NSCopying>*)p
{
  if (dps_ufill == [self activePreview])
    {
      [self setFilling: p];
    }
  else
    {
      [self setStroking: p];
    }
}
- (DPSUserPathAction)activePreview
{
  return painting_preview_get_active(&preview_data);
}
@end


void
paint_style_pallet_show()
{
  [[PaintStylePallet sharedObject] show];
}
void
paint_style_pallet_hide()
{
  [[PaintStylePallet sharedObject] hide];
}

PaintStylePallet *
paint_style_pallet()
{
  return [PaintStylePallet sharedObject];
}

/*
 * RGB dict
 */
static BOOL
rgb_load(PaintStylePallet * pallet)
{
  FILE * fp;
  char buf[64];
  char * color[3];
  char * n;
  int i, j;
  
  fp = rgb_open(rgb_txt_default_array);
  
  if (fp)
    {
      while(fgets(buf, 64, fp))
	{
	  if (buf[0] == '!') continue ;
	  for (i = 0; i < 12; i++)
	    if(buf[i] == ' ' || buf[i] == '\t')
	      buf[i] = '\0';
	  for(j = 0; j < 3; j++)
	    for(i = 0; i < 4; i++)
	      if (buf[j*4 + i] != '\0')
		{
		  color[j] = &buf[j*4 + i];
		  break;
		}
	  n = & buf[13];
	  if (*n == ' ' || *n == '\t')
	    n = &buf[14];	// TODO
	  n[strlen(n) - 1] = '\0';
	  [pallet setColor: [PSProcessColor  
			      processColorWithRed: 
				(float)atoi(color[0])/(float)255
			      green: 
				(float)atoi(color[1])/(float)255
			      blue: (float)atoi(color[2])/(float)255]
		  forName: [NSString stringWithCString: n]];
	}
      fclose (fp);
      return YES;
    }
  return NO;
}


static FILE * 
rgb_open(NSString ** rgbfile)
{
  FILE * result = NULL;
  while(rgbfile)
    {
      result = fopen([*rgbfile cString], "r");
      if (result) break;
      rgbfile++;
    }
  return result;
}
