/* PSConsole.h --- psconsole wrapper
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PostScriptConsole.h"
#include "psconsole.h"

@implementation PostScriptConsole
static PostScriptConsole * shared_ps_console = nil;
+ (GyveGUI *)sharedObject
{
  if (nil == shared_ps_console)
    shared_ps_console = [[self alloc] init];
  return shared_ps_console;
}
- init
{
  widget = psconsole_new("dps> ", "hello gyve\n");
  [super init];
  gtk_widget_hide(widget);
  return self;
}
@end


void
ps_console_show()
{
  [[PostScriptConsole sharedObject] show];
}  

void
ps_console_hide()
{
  [[PostScriptConsole sharedObject] hide];
}
  
PostScriptConsole *
ps_console()
{
  return shared_ps_console;
}
