/* TextStylePallet.h --- 
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "TextStylePallet.h"
#include "text_style_pallet.h"

static TextStylePallet * shared_text_style_pallet = nil;
@implementation TextStylePallet
+ (GyveGUI *)sharedObject
{
  if (nil == shared_text_style_pallet)
    shared_text_style_pallet = [[self alloc] init];
  return shared_text_style_pallet;
}
+ (TextStylePallet *)textStylePallet
{
  return (TextStylePallet *)[self sharedObject];
}
- init
{
  [super init];
  widget     = text_style_pallet_new(self);
  text_style = [[PSTextStyle alloc]
		 initWithFontName: @"Times-Roman"
		 size: 36.0];
  return self ;
}
- (void)installTextStyle: (id<PSTextStyle>)base_style
{
  [text_style installTextStyle: base_style];
}
- (void)setFontName: (bycopy NSString *)name
{
  [text_style setFontName: name];
}
- (NSString *)fontName
{
  return [text_style fontName];
}
- (void)setFontSize:(float)s;
{
  [text_style setFontSize: s];
}
- (float)fontSize
{
  return [text_style fontSize];
}
- (void)dealloc
{
  [text_style release];
  [super dealloc];
}
@end

void
text_style_pallet_show()
{
  [[TextStylePallet sharedObject] show];
}
void
text_style_pallet_hide()
{
  [[TextStylePallet sharedObject] hide];
}

TextStylePallet * 
text_style_pallet()
{
  return [TextStylePallet sharedObject];
}
