/* ToolBox.h --- toolbox wrappper
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef TOOL_BOX_H
#define TOOL_BOX_H 
#include <gyve/GyveGUI.h>
#include <gyve/GyveTool.h>
@interface ToolBox: GyveGUI
{
  NSObject<GyveTool>* tool;
}
+ (id<GyveGUI>)sharedObject;
- init;
+ (NSObject<GyveTool>*)tool;
+ (void)setTool: (NSObject<GyveTool>*)new_tool;
- (NSObject<GyveTool>*)tool;
- (void)setTool: (NSObject<GyveTool>*)new_tool;
@end

void toolbox_show();
void toolbox_hide();
ToolBox * toolbox();

#endif /* Not def: TOOL_BOX_H */
