/* ToolBox.m --- toolbox wrappper
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "pixmaps-gimp.h"
#include "ToolBox.h"
#include "toolbox.h"
#include "utilities.h"
#include "GyveEditingTool.h"
#include "GyveCreatingTool.h"
#include "GyveMiscTool.h"
#include "GuileConsole.h"
#include "PostScriptConsole.h"
#include "LayersPallet.h"
#include "PaintStylePallet.h"
#include "GyveBuffer.h"
#include "GyveWindow.h"
#include "TextStylePallet.h"
#include "GyveTextTool.h"

static void menu_window_new();

static void button_select(GtkButton *button, gpointer data);

static ToolBox * shared_tool_box = nil;
@implementation ToolBox
+ (id<GyveGUI>)sharedObject
{
  if (shared_tool_box == nil)
    shared_tool_box = [[ToolBox alloc] init];
  return (id<GyveGUI>)shared_tool_box;
}
- init
{
  GtkMenuEntry menu_items[] =
  {
    { "<Toolbox>/File/New Buffer", NULL, menu_window_new, NULL },
    { "<Toolbox>/File/Quit", NULL, (void (*)())exit, NULL },
    { "<Toolbox>/Dialog/Paint Style Pallet", NULL, paint_style_pallet_show, NULL },
    { "<Toolbox>/Dialog/Text Style Pallet", NULL, text_style_pallet_show, NULL },    
    { "<Toolbox>/Dialog/Layers Pallet", NULL, layers_pallet_show, NULL },
    { "<Toolbox>/Dialog/Guile Console", NULL, guile_console_show, NULL },
    { "<Toolbox>/Dialog/PS Console", NULL, ps_console_show, NULL },
  };
  struct gyveGtkToolButtonSpec button_specs[] =
  {
    {"Select", button_select, [[GyveSelectionTool alloc] init], NULL, move_bits},
    {"Direct", button_select,  [[GyveDirectionTool alloc] init], NULL, default_bits},
    {"Reshape", button_select, [[GyveReshapeTool alloc] init], NULL, default_bits},
    {"Zoom", button_select, [[GyveZoomTool alloc] init], NULL,magnify_bits},
    {"Pen", button_select, [[GyvePenTool alloc] init], NULL, bezier_bits},
    {"Scissors", gyve_button_not_implemented, NULL, NULL,NULL}, 
    {"Brush", gyve_button_not_implemented, NULL, NULL,NULL}, 
    {"FreeHand", gyve_button_not_implemented, NULL, NULL,NULL}, 
    {"Oval", button_select, [[GyveOvalTool alloc] init], NULL,circ_bits}, 
    {"Rectangle", button_select, [[GyveRectangleTool alloc] init], NULL, rect_bits},
    // {"Rectangle", button_select, [[GyveRectangleTool alloc] init], NULL, rect_bits},
    {"Ruler", gyve_button_not_implemented, NULL, NULL,NULL},
    {"Text", button_select, [[GyveTextTool alloc] init], NULL,text_bits},
    {"Rotate", button_select, [[GyveRotateTool alloc] init], NULL, rotate_bits},
    {"Scale", button_select, [[GyveScaleTool alloc] init], NULL, scale_bits},
    {"Reflect", gyve_button_not_implemented, NULL, NULL,NULL},
    {"Slant", gyve_button_not_implemented, NULL, NULL,NULL},
    {"Fill", gyve_button_not_implemented, NULL, NULL,NULL},
    {"Pick", gyve_button_not_implemented, NULL, NULL,NULL},
    {"Gradation", gyve_button_not_implemented, NULL, NULL,NULL},
    {"Blend", gyve_button_not_implemented, NULL, NULL,NULL}
  };
  gint nmenu_items = sizeof (menu_items)/ sizeof (menu_items[0]);
  gint nbutton_specs = sizeof (button_specs)/ sizeof(button_specs[0]);

  [super init];
  widget = toolbox_new(menu_items, nmenu_items, button_specs, nbutton_specs);
  tool = [(NSObject<GyveTool>*)(button_specs[0].data) retain];
  return self ;
}
+ (NSObject<GyveTool>*)tool
{
  return [(ToolBox *)[ToolBox sharedObject] tool];
}
+ (void)setTool: (NSObject<GyveTool>*)new_tool
{
  [(ToolBox *)[ToolBox sharedObject] setTool: new_tool];
}
- (NSObject<GyveTool>*)tool
{
  return tool;
}
- (void)setTool: (NSObject<GyveTool>*)new_tool
{
  ASSGIN_NSOBJECT(new_tool, tool);
}
@end

void
toolbox_show()
{
  [[ToolBox sharedObject] show];
}
void
toolbox_hide()
{
  [[ToolBox sharedObject] hide];
}
ToolBox * 
toolbox()
{
  return [ToolBox sharedObject];
}

static void
button_select(GtkButton *button, gpointer data)
{
  [(ToolBox *)[ToolBox sharedObject] setTool: data];
}

static NSString  * new_window_dialog_issue_name();
static GtkWidget * new_window_dialog_new();
static void new_window_dialog_destroy(GtkWidget *widget, gpointer data);
static void new_window_dialog_select(GtkWidget *widget, gpointer data);

static GtkWidget * size_selection_frame_new();
static void size_seleciton_set(GtkWidget *widget, gpointer data);

static NSString * new_window_dialog_size = @"A4";

static void
menu_window_new()
{
  GtkWidget * widget = new_window_dialog_new();
  gtk_widget_show(widget);
}

static NSString  *
new_window_dialog_issue_name()
{
  static int n 	     = 0;
  NSString * name    = [NSString stringWithFormat: @"%s-%d", "Untitled", ++n];
  return name;
}


static
GtkWidget * new_window_dialog_new()
{
  GtkWidget * frame;
  GtkWidget * button;
  GtkWidget * dialog = gtk_dialog_new ();
  
  gtk_window_set_title (GTK_WINDOW(dialog), "New window");
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		      &dialog);
  gtk_container_border_width (GTK_CONTAINER (dialog), 0);

  
  frame = size_selection_frame_new();
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), frame);
  gtk_widget_show(frame);
  
  button = gtk_button_new_with_label ("OK");
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (new_window_dialog_select),
		      GTK_OBJECT(dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
		      button, TRUE, TRUE, 0);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);
  
  button = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (new_window_dialog_destroy),
		      GTK_OBJECT(dialog));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);

  return dialog;
}

static void
new_window_dialog_destroy(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

static void
new_window_dialog_select(GtkWidget *widget, gpointer data)
{
  NSString * request 	= new_window_dialog_size;
  GyveBuffer * buf;
  
  if (YES == [request isEqual: @"A4"])
    buf = [[[GyveBuffer alloc] initWithWidth: 600
			       height: 450
			       name: new_window_dialog_issue_name()]
	    autorelease];    
  else if (YES == [request isEqual: @"A5"])
    buf = [[[GyveBuffer alloc] initWithWidth: 750 
			       height: 500
			       name: new_window_dialog_issue_name()]
	    autorelease];    
  else if (YES == [request isEqual: @"Letter"])
    buf = [[[GyveBuffer alloc] initWithWidth: 500
			       height: 275
			       name: new_window_dialog_issue_name()]
	    autorelease];    
  else
    {
      buf = nil;
      fprintf(stderr, "wrong document size[%s]\n", [request cString]);
    }
  
  if (nil != buf)
    {
        GyveWindow * win = [[[GyveWindow alloc] initWithBuffer: buf] autorelease];
	[win show];
	[GyveWindow setCurrentWindow: win];
    }  
  gtk_widget_destroy(GTK_WIDGET(data));
}

static GtkWidget *
size_selection_frame_new()
{
  GtkWidget * inner_container;
  GtkWidget * frame;
  GtkWidget * button;
  GSList * group;
  
  frame  = gtk_frame_new ("Document size");
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  inner_container = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (inner_container), 10);
  gtk_container_add (GTK_CONTAINER (frame), inner_container);
  gtk_widget_show (inner_container);
  
  button = gtk_radio_button_new_with_label (NULL, "A4");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (size_seleciton_set),
		      @"A4");
  gtk_box_pack_start (GTK_BOX (inner_container), button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (button);
  
  group  = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
  button = gtk_radio_button_new_with_label(group, "A5");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (size_seleciton_set), 
		      @"A5");
  gtk_box_pack_start (GTK_BOX (inner_container), button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (button);

  group = gtk_radio_button_group (GTK_RADIO_BUTTON(button));
  button = gtk_radio_button_new_with_label(group, "Letter");
  gtk_signal_connect (GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC (size_seleciton_set), 
		      @"Letter");
  gtk_box_pack_start (GTK_BOX (inner_container), button, TRUE, TRUE, 0);
  gtk_widget_show (button);

  return frame;
}

static void
size_seleciton_set(GtkWidget *widget, gpointer data)
{
  new_window_dialog_size = data;
}


