#include "GyveDrawingEngine.h"
#include <Foundation/NSObject.h>
#include <Foundation/NSGeometry.h>
#include <DPS/psops.h>

@interface SampleEngine: NSObject<GyveDrawingEngine>
@end

@implementation SampleEngine
- (void)setAbsoluteScale:(float) scale {}
- (float)absoluteScale {return 1.0;}
- (enum drawing_mode)drawingMode
{
  return 0;
}
- (void)setDrawingMode: (enum drawing_mode)mode
{
}
- (void)redrawRect: (NSRect *)rect
{
  PSsetrgbcolor(1.0, 0.0, 0.0);
  PSrectfill(rect->origin.x, rect->origin.y,
	     rect->size.width, rect->size.height);

  PSsetrgbcolor(0.0, 1.0, 0.0);
  PSrectfill(rect->origin.x + 30 , rect->origin.y+ 30,
	     rect->size.width, rect->size.height);

  PSsetrgbcolor(0.0, 0.0, 1.0);
  PSrectfill(rect->origin.x + 60 , rect->origin.y+ 60,
	     rect->size.width, rect->size.height);

}
- (void)imageCacheRequestWithArea: (GtkDPSArea * )area
			  coordTr: (struct coord_tr *)_coord_tr {}
- (void)coordTrChangesTo: (struct coord_tr *)coord_tr {}
- (void)setDocumentSize: (NSSize *) size {}
- (NSSize)documentSize { return NSZeroSize; }
- (BOOL)calcBBoxOfFigObj: (NSObject<PSFigObj>*)figobj {return  NO;}
@end
