/* containing.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef CONTAINING_H
#define CONTAINING_H 
/* 
 * XXXContaining
 * Idea and methods name are borrowed from <base/Collecting.h> 
 */

#include <Foundation/NSGeometry.h>
#include <gyve/enumerating.h>

@class NSPointValue;
@protocol PointsContaining
- (int)countPoints;
- (NSPoint *)pointAtIndex: (int)n;
- (NSPointValue *) pointValueAtIndex:(int)index;
- (NSPointValue *)firstPointValue;
- (NSPoint *)firstPoint;
- (NSPoint *)lastPoint;
- (NSPointValue *)lastPointValue;
- (id<PointsEnumerating>)pointsEnumerator;
- (id<PointsEnumerating>)reversePointsEnumerator;
- (BOOL)containsPoint: (const NSPoint *)point;
- (BOOL)containsPointValue: (const NSPointValue *)point;
@end

@class PSSegment;
@protocol SegmentsContaining
- (int)countSegments;
- (PSSegment *)firstSegment;
- (PSSegment *)segmentAtIndex: (int)n;
- (int)indexOfSegment: (PSSegment *)seg;
- (PSSegment *)lastSegment;
- (id<SegmentsEnumerating>)segmentsEnumerator;
- (id<SegmentsEnumerating>)reverseSegmentsEnumerator;
- (BOOL)containsSegment: (PSSegment *)segment;
@end

@protocol FigObjsContaining
- (int)countFigObjs;
- (BOOL)containsFigObj:  (id<PSFigObj>)figobj;
- (int)indexOfFigObj: (id<PSFigObj>)figobj;
- (id<PSFigObj>)figObjAtIndex: (int)n;
- (id<PSFigObj>)firstPrimitiveFigObj;
- (id<PSFigObj>)lastPrimitiveFigObj;
- (id<PSFigObj>)firstFigObj;
- (id<PSFigObj>)lastFigObj;
- (id<FigObjsPrimitiveEnumerating>)primitiveFigObjsEnumerator;
- (id<FigObjsPrimitiveEnumerating>)reversePrimitiveFigObjsEnumerator;
- (id<FigObjsEnumerating>)figObjsEnumerator;
- (id<FigObjsEnumerating>)reverseFigObjsEnumerator;
@end

@protocol LayerContaining
- (BOOL)containsLayer: (GyveLayer *)layer;
- (int)countLayers;
- (int)indexOfLayer: (GyveLayer *)layer;
- (GyveLayer *)layerAtIndex: (int)n;
- (GyveLayer *)firstLayer;
- (GyveLayer *)lastLayer;
- (id<LayerEnumerating>)layerEnumerator;
- (id<LayerEnumerating>)reverseLayerEnumerator;
@end
#endif /* Not def: CONTAINING_H */
