/* dps.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef DPS_H
#define DPS_H 

#include <DPS/dpsfriends.h>
#include <gyve/utilities.h>

typedef long int userobject ;
@protocol PSUserObject
- (void)bindToUserobject: (userobject)i inContext:(DPSContext)ctxt;
- (userobject)userobject;
@end

extern const userobject userobject_unbound;
void userobject_new(id<PSUserObject>obj);
void userobject_bind(userobject index, id<PSUserObject>obj);
void userobject_release(userobject index); 

#endif /* Not def: DPS_H */
