/* dps.m --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "dps.h"
#include "utilities.h"
#include "Gyve.h"

#include <Foundation/NSValue.h>
#include <DPS/dpsXclient.h>
#include <Foundation/NSSet.h>

const userobject userobject_unbound = 0;
static NSMutableSet * userobjects_set = nil;

void
userobject_new(id<PSUserObject>obj)
{
  NSNumber * numobj;
  int num;
  if (userobjects_set && ([userobjects_set count] > 0))
    {
      numobj = [userobjects_set anyObject];
      num    = [numobj intValue];
      [userobjects_set removeObject: numobj];
    }
  else
    num = DPSNewUserObjectIndex();

  if (nil != obj) userobject_bind(num , obj);
}

void
userobject_release(userobject uo)
{
  if (nil == userobjects_set)
    userobjects_set = [[NSMutableSet alloc] init];
  [userobjects_set addObject: [NSNumber numberWithInt: uo]];
}

void
userobject_bind(userobject index, id<PSUserObject>obj)
{
  [obj bindToUserobject: index inContext: [Gyve sharedDPSContext]];
}
