/* enumerating.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_ENUMERATING_H
#define GYVE_ENUMERATING_H 

#include <gyve/PSFigObj.h>
#include <Foundation/NSGeometry.h>
#include <gyve/utilities.h>

@class NSPointValue;

@protocol EnumerationWithFiltering
- (void)setEnumerationFilter: (id_predicator_t *)filter;
@end

@protocol PointsEnumerating<EnumerationWithFiltering>
- nextObject;
- (const NSPoint *)nextPoint;
- (NSPointValue *)nextPointValue;
@end

@class PSSegment;
@protocol SegmentsEnumerating<EnumerationWithFiltering>
- nextObject;
- (PSSegment *)nextSegment;
@end


@protocol FigObjsPrimitiveEnumerating<EnumerationWithFiltering>
- nextObject;
- (id<PSFigObj>)nextPrimitiveFigObj;
@end

@protocol FigObjsEnumerating<EnumerationWithFiltering>
- nextObject;
- (id<PSFigObj>)nextFigObj;
@end

@class GyveLayer;

@protocol LayerEnumerating<EnumerationWithFiltering>
- nextObject;
- (GyveLayer *)nextLayer;
@end

#endif /* Not def: GYVE_ENUMERATING_H */
