/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
  GConsole -- yet another guile console widget
  Author: Eiichi Takamori <taka@ma1.seikyou.ne.jp>
 */

#ifndef __GCONSOLE_H__
#define __GCONSOLE_H__

#include <gtk/gtkwindow.h>
#include <gtk/gtkadjustment.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GCONSOLE(obj)          GTK_CHECK_CAST (obj, gconsole_get_type (), GConsole)
#define GCONSOLE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gconsole_get_type (), GConsoleClass)
#define IS_GCONSOLE(obj)       GTK_CHECK_TYPE (obj, gconsole_get_type ())


typedef struct _GConsoleFlush	GConsoleFlush;
typedef struct _GConsole	GConsole;
typedef struct _GConsoleClass	GConsoleClass;

struct _GConsoleFlush
{
  guint	flushing : 1;
  guint flush_pos;
  guint saved_pos;
  guint idle_tag;
  guint timeout_tag;
};

struct _GConsole
{
  GtkWindow window;

  gchar *prompt;
  GList *history;
  GList *history_current;
  GtkWidget *text;
  GtkWidget *entry;
  GtkAdjustment *vadj;
  GConsoleFlush flush;
};

struct _GConsoleClass
{
  GtkWindowClass parent_class;
};

guint gconsole_get_type(void);
GtkWidget *gconsole_new(gchar *prompt, gchar *initial_message);
void gconsole_output(GConsole *con, gchar *string);

#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* __GCONSOLE_H__ */



/*
 * Local Variables:
 * Mode: c
 * c-basic-offset: 2
 * End:
 */
