/* geometry.h --- Interface for geometry releated routines for GYVE

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GEOMETRY_H
#define GEOMETRY_H 

#include <gyve/constant.h>
#include <gtk/gtk.h>
#include <Foundation/NSGeometry.h> 
#include <DPS/dpsfriends.h>


enum bbox_element_index {BBOX_LLX=0, BBOX_LLY=1, BBOX_URX=2, BBOX_URY=3};
struct bbox {
  NSPoint lower_left;
  NSPoint upper_right;
};

/*
 * NSPoint releated functions
 */
/* NSPoint_copy: src->dist */
void NSPoint_copy(const NSPoint * src, NSPoint * dist);

/* NSPoint_copy: src->distnĥԡ. */
void NSPoint_ncopy(const NSPoint * src, NSPoint * dist, const int n);

/* NSPoint_in_bbox: bbox뤫ɤȽ */
BOOL NSPoint_in_bbox(const NSPoint * point, const struct bbox * bbox);

/* NSPoint_distance: 2֤εΥ */
float NSPoint_distance(const NSPoint * a, const NSPoint * b);

/* NSPoint_power_of_distance: 2֤εΥ2
   ¿ξ, ΥɬӤΤǤ, 
   sqrtȤɬפޤǤϤʤ. */
float NSPoint_power_of_distance(const NSPoint * a, const NSPoint * b);

BOOL NSPoint_equal(const NSPoint * p, const NSPoint * q);
BOOL NSPoint_is_zero_point(const NSPoint * p);

/* a - b */
void NSPoint_diff (NSPoint * a, NSPoint * b, NSPoint * result);

/* a + b */
void NSPoint_add (NSPoint * a, NSPoint * b, NSPoint * result);

void NSPoint_from_gtkAllocation(NSPoint * start, /* if NULL don't calc */
				NSPoint * end,   /* if NULL don't calc */
				GtkAllocation * allocation);

void NSPoint_print(NSPoint * p, FILE * stream);

/* 
 * BBox 
 *
 * Ĺ򺸲ȱꤹǡ¤
 *
 */

/* */
void bbox_copy(const struct bbox * src, struct bbox * dist);

/* return the value of bbox at index */ 
float bbox_element(const struct bbox * bbox, const enum bbox_element_index index);

/* set the value of bbox at index */
void bbox_set(struct bbox * bbox, const enum bbox_element_index index, const float value);

/* init bbox from point a and b */
void bbox_make(struct bbox * bbox, const NSPoint * a, const NSPoint * b);

/* return YES if BIG contains small */
BOOL bbox_in_bbox(const struct bbox * big, const struct bbox * small);

/* See NSRect_expand_by_delta
  */
void bbox_expand_by_delta(struct bbox * bbox, float delta);

/* return YES if expanded 
   bbox will be expanded(changed).
   point will not be changed.
   If BBOX is a zero bbox, the value of point is assigned to LL and 
   UR of BBOX */
BOOL bbox_expand_by_point(struct bbox * bbox, const NSPoint * point);

/* return YES if expanded 
   MASTER will be expanded(changed).
   EXPANDER will not be changed. 
   If MASTER is a zero bbox, the value of EXPANDER is assigned to MASTER. 
   If EXPANDER is a zero bbox, This funciton does noting. */
BOOL bbox_expand_by_bbox(struct bbox * master, const struct bbox * expander);

/* */
void bbox_to_rect(const struct bbox * from_bbox, NSRect * to_rect);

/* your_bbox = zero_bbox; */
extern const struct bbox zero_bbox;

/* */
BOOL bbox_is_zero_bbox (const struct bbox * bbox);

/* bboxɤŤʤ꤬뤫ɤĴ٤. 
   FIXME: ؿ̾? */
BOOL bbox_intersects (const struct bbox * a, const struct bbox * b);

/* */
BOOL bbox_contains_point (const struct bbox * bbox, const NSPoint * point);
  
BOOL bbox_equal(const struct bbox * a, const struct bbox * b);

/* FOR DEBUGGING */
void bbox_print(const struct bbox * bbox, FILE *stream);


/*
 */
void bbox_from_points(struct bbox * bbox, NSPoint * a, NSPoint * b);

/*
 */
NSPoint bbox_center(struct bbox * bbox);

/*
 * NSSize
 */
void NSSize_copy(const NSSize * src, NSSize * dist);

/* p0 - p1 */
void NSSize_from_points(NSSize * size,  NSPoint * p0, NSPoint * p1);

void NSSize_from_gtkAllocation(NSSize * size, GtkAllocation * allocation);

/* a - b */
void NSSize_diff (NSSize * a, NSSize * b, NSSize * result);

BOOL NSSize_is_zero_size(NSSize * size);


/*
 * NSRect
 */
/* */
void NSRect_copy(const NSRect * src, NSRect * dist);

/* */
void NSRect_to_bbox(const NSRect * from_rect, struct bbox * to_bbox);

/* NSRect_from_points: create from points */
void NSRect_from_points(NSRect * rect, const NSPoint * a, const NSPoint * b);

/* NSRect_expand_by_delta: DELTA *岼*rect . */
void NSRect_expand_by_delta(NSRect * rect, const float delta);

/* YES is (equal? rect NSZeroRect) */
BOOL NSRect_is_zero_rect(const NSRect * rect);

/* NSRect
          end
   +-------+
   |       |
   |       |
   +-------+
 origin      */
NSPoint NSRect_origin(NSRect * rect);
NSPoint NSRect_end(NSRect * rect);
void NSRect_from_gtkAllocation(NSRect * rect, GtkAllocation * allocation);
void NSRect_from_NSSize(NSRect * rect, NSSize * size);
void NSRect_from_center(NSRect * rect, NSPoint * p, float h, float w);
NSPoint NSRect_center(NSRect * rect);

/* For debug */
void NSRect_print(const NSRect * rect, FILE * stream);


/*
 * Matrix
 *   
 *  A  C  TX
 *     
 *  B  D  TY
 *
 *  0  0   1
 */

enum matrix_element_index 
{
  MATRIX_A = 0, MATRIX_B = 1, MATRIX_C = 2 , MATRIX_D = 3, 
  MATRIX_TX = 4, MATRIX_TY = 5
};
void matrix_init(float * matrix);
void matrix_apply_on_point(float * matrix, NSPoint * point);
void matrix_apply_on_matrix(float * matrix, float * target);

/* bboxǤޤ줿ͳѷbboxŬѤ, bbox. */
void matrix_apply_on_bbox(float * matrix, struct bbox * target);

void matrix_copy(float * src, float * dist);

/* Return NO if base_matrix is not regular 
 if new_matrix is NULL, don' calculate the inverse but
 check base_matrix is regular or not. */
BOOL matrix_invert(float * base_matrix, float * new_invert_matrix);
void matrix_print(float * matrix, FILE * stream);

BOOL matrix_equal(const float * a, const float * b);

/* Coord tr
   X <-> DPSκɸѴ˴Ϣؿȹ¤ */
struct coord_tr
{
  BOOL updated;    
  float ctm[6];
  float invctm[6];
  int x_offset;
  int y_offset;
};

void coord_tr_copy(struct coord_tr * src, 
		   struct coord_tr * dist);

void coord_tr_x2dps(struct coord_tr * tr, 
		    int in_x, int in_y, 
		    float * out_x, float * out_y);

void coord_tr_dps2x(struct coord_tr * tr, 
		    float in_x, float in_y, 
		    int * out_x, int * out_y);

void coord_tr_dpsRect2xRect(struct coord_tr * tr, 
			    NSRect * in_dps_rect,
			    NSRect * out_x_rect);
void coord_tr_get(struct coord_tr * tr, DPSContext ctxt);

#endif /* Not def: GEOMETRY_H */
