/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtkfbox.h"


static void gtk_fold_box_class_init    (GtkFoldBoxClass   *klass);
static void gtk_fold_box_init          (GtkFoldBox        *box);


guint
gtk_fold_box_get_type ()
{
  static guint fold_box_type = 0;

  if (!fold_box_type)
    {
      GtkTypeInfo fold_box_info =
      {
	"GtkFoldBox",
	sizeof (GtkFoldBox),
	sizeof (GtkFoldBoxClass),
	(GtkClassInitFunc) gtk_fold_box_class_init,
	(GtkObjectInitFunc) gtk_fold_box_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };

      fold_box_type = gtk_type_unique (gtk_box_get_type (), &fold_box_info);
    }

  return fold_box_type;
}

static void
gtk_fold_box_class_init (GtkFoldBoxClass *class)
{
  GtkWidgetClass *widget_class;

  widget_class = (GtkWidgetClass*) class;
}

static void
gtk_fold_box_init (GtkFoldBox *fold_box)
{
  fold_box->child_min_width = 20;
  fold_box->child_min_height = 20;
}
