/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtkvfbox.h"


static void gtk_vfold_box_class_init    (GtkVFoldBoxClass   *klass);
static void gtk_vfold_box_init          (GtkVFoldBox        *box);
static void gtk_vfold_box_size_request  (GtkWidget      *widget,
					 GtkRequisition *requisition);
static void gtk_vfold_box_size_allocate (GtkWidget      *widget,
					 GtkAllocation  *allocation);


guint
gtk_vfold_box_get_type ()
{
  static guint vfold_box_type = 0;

  if (!vfold_box_type)
    {
      GtkTypeInfo vfold_box_info =
      {
	"GtkVFoldBox",
	sizeof (GtkVFoldBox),
	sizeof (GtkVFoldBoxClass),
	(GtkClassInitFunc) gtk_vfold_box_class_init,
	(GtkObjectInitFunc) gtk_vfold_box_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };

      vfold_box_type = gtk_type_unique (gtk_fold_box_get_type (), &vfold_box_info);
    }

  return vfold_box_type;
}

static void
gtk_vfold_box_class_init (GtkVFoldBoxClass *class)
{
  GtkWidgetClass *widget_class;

  widget_class = (GtkWidgetClass*) class;

  widget_class->size_request = gtk_vfold_box_size_request;
  widget_class->size_allocate = gtk_vfold_box_size_allocate;
}

static void
gtk_vfold_box_init (GtkVFoldBox *vfold_box)
{
}

GtkWidget*
gtk_vfold_box_new ()
{
  GtkVFoldBox *vfold_box;

  vfold_box = gtk_type_new (gtk_vfold_box_get_type ());
  return GTK_WIDGET (vfold_box);
}


static void
gtk_vfold_box_size_request (GtkWidget      *widget,
			    GtkRequisition *requisition)
{
  GtkBoxChild *child;
  GList *children;

  children = GTK_BOX (widget)->children;
  while (children)
    {
      child = children->data;
      children = children->next;

      if (GTK_WIDGET_VISIBLE (child->widget))
	{
          gtk_widget_size_request (child->widget, &child->widget->requisition);
	}
    }

  requisition->width = 50;
  requisition->height = 100;
}

static void
gtk_vfold_box_size_allocate (GtkWidget     *widget,
			     GtkAllocation *allocation)
{
  GtkBoxChild *child;
  GList *children;
  GtkAllocation child_allocation;
  gint child_req_width;
  gint child_req_height;
  gint max_h;
  gint x;
  gint y;
  gint width;
  
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_VFOLD_BOX (widget));
  g_return_if_fail (allocation != NULL);


  children = GTK_BOX (widget)->children;
  x = allocation->x;
  y = allocation->y;
  width = allocation->width;
  max_h = 0;

  while (children)
    {
      child = children->data;
      children = children->next;

      if (GTK_WIDGET_VISIBLE (child->widget))
	{
	  child_req_width  = child->widget->requisition.width;
	  child_req_height = child->widget->requisition.height;

	  if ((x != 0) && ((x + child_req_width) > width))
	    {
	      x = allocation->x;
	      y += max_h;
	      max_h = 0;
	    }

	  child_allocation.width = child_req_width;
	  child_allocation.height = child_req_height;
	  child_allocation.x = x;
	  child_allocation.y = y;
	  gtk_widget_size_allocate (child->widget, &child_allocation);

	  x += child_req_width;
	  max_h = MAX (max_h, child_req_height);
	}
    }
}
