/* line_style_pallet.c --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "line_style_pallet.h"
#include <gtk/gtk.h>
#include "Gyve.h"
#include "GyveBuffer.h"
#include "GyveSelectionsLayer.h"
#include "PSPaintStyle.h"
#include "PSFigObj.h"

#define LINEWIDTH_MAX_FLOAT 100

static enum process_phase {GUI, NOTIFICATION} process_phase = GUI;

static GtkObject *linewidth_adjutment;

GtkWidget * joins_button[3];
static enum ps_line_join joins_button_to_line_join (GtkWidget * button);

static void create_line_join_frame (GtkWidget * container);
static void create_line_width_frame (GtkWidget * container);

/*
 * Call back
 */ 
static void joins_value_changed_callback (GtkWidget *widget,
					  gpointer data);
static void linewidth_value_changed_callback (GtkAdjustment * adjustment,
					      gpointer data);

static void joins_value_set (enum ps_line_join join);
static void linewidth_value_set (float width);

void 
create_line_style_pallet ()
{
  static GtkWidget *window = NULL;
  GtkWidget *box;
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Line style");
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  
  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box);
  gtk_widget_show (box);

  create_line_join_frame (box);
  create_line_width_frame (box);

  gtk_widget_show (window);
}


static void
create_line_join_frame (GtkWidget * container)
{
  GtkWidget * frame = gtk_frame_new ("Line joins");
  GtkWidget * inner_container;
  GSList * group;

  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  gtk_box_pack_start (GTK_BOX (container), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  inner_container = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (inner_container), 10);
  gtk_container_add (GTK_CONTAINER (frame), inner_container);
  gtk_widget_show (inner_container);

  joins_button[mitered_joins] = gtk_radio_button_new_with_label (NULL, 
								 "mitered joins");
  gtk_signal_connect (GTK_OBJECT (joins_button[mitered_joins]), "clicked",
		      GTK_SIGNAL_FUNC (joins_value_changed_callback), 
		      NULL);

  gtk_box_pack_start (GTK_BOX (inner_container), joins_button[mitered_joins], 
		      TRUE, TRUE, 0);
  gtk_widget_show (joins_button[mitered_joins]);

  group = gtk_radio_button_group (GTK_RADIO_BUTTON (joins_button[mitered_joins]));
  joins_button[round_joins] = gtk_radio_button_new_with_label(group, "round joins");
  gtk_signal_connect (GTK_OBJECT (joins_button[round_joins]), "clicked",
		      GTK_SIGNAL_FUNC (joins_value_changed_callback), 
		      NULL);

  gtk_box_pack_start (GTK_BOX (inner_container), joins_button[round_joins], 
		      TRUE, TRUE, 0);
  gtk_widget_show (joins_button[round_joins]);

  group = gtk_radio_button_group (GTK_RADIO_BUTTON (joins_button[round_joins]));
  joins_button[beveled_joins] = gtk_radio_button_new_with_label(group,
								"beveled joins");
  gtk_signal_connect (GTK_OBJECT (joins_button[beveled_joins]), "clicked",
		      GTK_SIGNAL_FUNC (joins_value_changed_callback), 
		      NULL);

  gtk_box_pack_start (GTK_BOX (inner_container), joins_button[beveled_joins], 
		      TRUE, TRUE, 0);
  gtk_widget_show (joins_button[beveled_joins]);
  
  //
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (joins_button[beveled_joins]), TRUE);
}
 
static void
create_line_width_frame (GtkWidget * container)
{
  GtkWidget *scrollbar;
  GtkWidget * scale;
  GtkWidget * inner_container;
  GtkWidget * frame = gtk_frame_new ("Line width");

  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  gtk_box_pack_start (GTK_BOX (container), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  inner_container = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (inner_container), 10);
  gtk_container_add (GTK_CONTAINER (frame), inner_container);
  gtk_widget_show (inner_container);
  
  linewidth_adjutment = gtk_adjustment_new (0.0, 0.0, LINEWIDTH_MAX_FLOAT, 
					    0.1, 1.0, 1.0);
  gtk_adjustment_set_value(GTK_ADJUSTMENT(linewidth_adjutment), 1.0);

  gtk_signal_connect (GTK_OBJECT (linewidth_adjutment), "value_changed",
		      (GtkSignalFunc) linewidth_value_changed_callback, NULL);
  scale = gtk_hscale_new (GTK_ADJUSTMENT (linewidth_adjutment));
  gtk_widget_set_usize (GTK_WIDGET (scale), 150, 30);
  gtk_range_set_update_policy (GTK_RANGE (scale), GTK_UPDATE_DELAYED);
  gtk_scale_set_digits (GTK_SCALE (scale), 1);
  gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
  gtk_box_pack_start (GTK_BOX (inner_container), scale, TRUE, TRUE, 0);
  gtk_widget_show (scale);
  
  scrollbar = gtk_hscrollbar_new (GTK_ADJUSTMENT (linewidth_adjutment));
  gtk_range_set_update_policy (GTK_RANGE (scrollbar), 
			       GTK_UPDATE_CONTINUOUS);
  gtk_box_pack_start (GTK_BOX (inner_container), scrollbar, TRUE, TRUE, 0);
  gtk_widget_show (scrollbar);  
}

static
enum ps_line_join joins_button_to_line_join (GtkWidget * button)
{
  if (button == joins_button[mitered_joins])
    return mitered_joins;
  else if (button == joins_button[round_joins])
    return round_joins;
  else if (button == joins_button[beveled_joins])
    return beveled_joins;
  else
    return -1;
}

static 
void joins_value_changed_callback (GtkWidget *widget, gpointer data)
{
  enum ps_line_join join = joins_button_to_line_join(widget);
  GyveSelectionsLayer * layer;
  GyveBuffer * buffer;

  if (process_phase == NOTIFICATION) return ;
  if (GTK_TOGGLE_BUTTON(widget)->active == 0) return ;

  buffer = [(Gyve *)GTKApp documentBuffer];
  if (buffer == nil) return ;
  layer = [buffer selectionsLayer];
  // set
  // redraw
}

static void 
linewidth_value_changed_callback (GtkAdjustment * adjustment,
				  gpointer data)
{
  id<PSFigObj> figobj;
  PSFigObjOnBufferProxy * figobj_proxy;
  GyveSelectionsLayer * layer;
  GyveBuffer * buffer;
  float value = adjustment->value;

  if (process_phase == NOTIFICATION) return ;

  buffer = [(Gyve *)GTKApp documentBuffer];
  if (buffer == nil)
    {
      // ̵¥롼פǽ.
      [[(Gyve *)GTKApp defaultPaintStyle] setLineWidth: value];
      return ;
    }

  layer = [buffer selectionsLayer];
  if ([layer count] == 0)
    {
      // ̵¥롼פǽ.
      [[(Gyve *)GTKApp defaultPaintStyle] setLineWidth: value];
      return ;
    }
  else
    {
      int i;
      int max = [layer count];
      for (i = 0; i < max; i++)
	{
	  figobj_proxy = [layer objectAtIndex: i];
	  figobj = (id<PSFigObj>)[figobj_proxy beginModificationByCopy];
	  {
	    // 
	  }
	  [figobj_proxy endModification];
	}
    }
}


static void
joins_value_set (enum ps_line_join join)
{
  int max = 3, i;
  enum process_phase old_process_phase = process_phase;
  process_phase = NOTIFICATION;
  for (i = 0; i < max; i++)
    {
      if (join == i) 
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (joins_button[i]), TRUE);
      else
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (joins_button[i]), FALSE);
    }
  process_phase = old_process_phase;
}

static void
linewidth_value_set (float width)
{
  enum process_phase old_process_phase = process_phase;
  process_phase = NOTIFICATION;
  gtk_adjustment_set_value(GTK_ADJUSTMENT(linewidth_adjutment), width);
  process_phase = old_process_phase;
}
