/* main.m --- main driver for gyve

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 


#include "constant.h"
#include "Gyve.h"

#ifndef id
#define id idx
#endif /* Not def: id */
#include <guile/gh.h>
#undef id

#include <Foundation/NSAutoreleasePool.h>

static void gyve_main ();

int
main (int argc, char ** argv)
{
  gh_enter(argc, argv, gyve_main);
  return 0;
}


static void
gyve_main (argc, argv)
     int argc;
     char **argv;
{
  Gyve * gyve;
  NSAutoreleasePool * pool_for_init = [[NSAutoreleasePool alloc] init];
  gyve = [[Gyve alloc]
	   initWithArguments:argv
	   count:argc
	   environment:NULL];
  [pool_for_init release], pool_for_init = nil;
  [gyve run];
  [gyve release], gyve = nil;
}
