/* paint_style_pallet.m

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by: Hideki FUJIMOTO 
               Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "paint_style_pallet.h"
#include "PaintStylePallet.h"
#include "constant.h"
#include "GyveGUI.h"
#include "Gyve.h"
#include "painting_preview.h"
#include "PSProcessColor.h"
#include "PSCustomColor.h"

static GtkWidget * process_color_pallet_new(PaintStylePallet * pallet);
static GtkWidget * custom_color_pallet_new(PaintStylePallet * pallet);
static GtkWidget * pattern_pallet_new(PaintStylePallet * pallet);
static GtkWidget * gradation_pallet_new(PaintStylePallet * pallet);

static GtkWidget * line_style_pallet_new(PaintStylePallet * pallet);
GtkWidget *
paint_style_pallet_new(PaintStylePallet * pallet)
{
  GtkWidget *window = NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *boxh;
  GtkWidget *button;
  GtkWidget *separator;
  GtkWidget * page;
  GtkWidget * label;
  GtkWidget * notebook;
  GtkWidget * preview;
  gint old_mask;
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_hide),
		      &window);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_hide),
		      &window); 
  
  gtk_window_set_title (GTK_WINDOW (window), "Paint Style");
  gtk_container_border_width (GTK_CONTAINER (window), 0);

  /* Added mode switch */
  old_mask = gtk_widget_get_events(GTK_WIDGET(window));
  gtk_widget_set_events(GTK_WIDGET(window), old_mask| GDK_ENTER_NOTIFY_MASK);
  gtk_signal_connect(GTK_OBJECT(window), "enter_notify_event",
		     GTK_SIGNAL_FUNC (gui_enter_interactive_mode),
		     NULL);
  
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box1);
  gtk_widget_show (box1);

  boxh = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (boxh), 10);
  gtk_box_pack_start (GTK_BOX (box1), boxh, TRUE, TRUE, 0);
  gtk_widget_show (boxh);

  preview = painting_preview_new(&(pallet->preview_data));
  gtk_box_pack_start (GTK_BOX (boxh), preview, TRUE, TRUE, 0);
  gtk_widget_show (preview);
  
  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (boxh), box2, TRUE, TRUE, 0);
  gtk_widget_show (box2);

  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (box2), notebook, TRUE, TRUE, 0);
  gtk_widget_show (notebook);

  page = process_color_pallet_new(pallet);
  gtk_widget_show(page);
  label = gtk_label_new("Process Color");
  gtk_notebook_append_page(GTK_NOTEBOOK (notebook), page, label);

  page = custom_color_pallet_new(pallet);
  gtk_widget_show(page);
  label = gtk_label_new("Custom Color");
  gtk_notebook_append_page(GTK_NOTEBOOK (notebook), page, label);

  page = pattern_pallet_new(pallet);
  gtk_widget_show(page);
  label = gtk_label_new("Pattern");
  gtk_notebook_append_page(GTK_NOTEBOOK (notebook), page, label);

  page = gradation_pallet_new(pallet);
  gtk_widget_show(page);
  label = gtk_label_new("Gradation");
  gtk_notebook_append_page(GTK_NOTEBOOK (notebook), page, label);

  page = line_style_pallet_new(pallet);
  gtk_widget_show(page);
  label = gtk_label_new("Line Style");
  gtk_notebook_append_page(GTK_NOTEBOOK (notebook), page, label);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);

  box2 = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
  gtk_widget_show (box2);
  
  button = gtk_button_new_with_label ("Close");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC (paint_style_pallet_hide),
			     GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  return window;  
}


/* Line style pallet */
static GtkWidget * line_joins_frame_new (PaintStylePallet * pallet);
static GtkWidget * line_caps_frame_new (PaintStylePallet * pallet);
static GtkWidget * line_width_frame_new (PaintStylePallet * pallet);

static void line_joins_value_changed (GtkWidget *widget, gpointer data);
static void line_caps_value_changed (GtkWidget *widget, gpointer data);
static void line_width_value_changed (GtkAdjustment * adjustment, gpointer data);

/*
static GtkWidget * line_dash_frame_new (PaintStylePallet * pallet);
*/

static GtkWidget *
line_style_pallet_new(PaintStylePallet * pallet)
{
  GtkWidget * vbox = gtk_vbox_new (FALSE, 0);
  GtkWidget * hbox = gtk_hbox_new (FALSE, 0);
  GtkWidget * frame;

  frame = line_caps_frame_new(pallet);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show(frame);
  
  frame = line_joins_frame_new(pallet);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show(frame);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);
  
  frame = line_width_frame_new(pallet);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show(frame);
  
  return vbox;
}

static GtkWidget *
line_joins_frame_new (PaintStylePallet * pallet)
{
  GtkWidget * frame;
  GtkWidget * inner_container;
  GtkWidget * button;
  GSList * group;

  frame  = gtk_frame_new ("Line joins");
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  
  inner_container = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (inner_container), 10);
  gtk_container_add (GTK_CONTAINER (frame), inner_container);
  gtk_widget_show (inner_container);
  
  button = gtk_radio_button_new_with_label (NULL, "mitered");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (line_joins_value_changed),
		      pallet);
  gtk_box_pack_start (GTK_BOX (inner_container), button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (button);
  pallet->joins_button[mitered_joins] = button;

  group  = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
  button = gtk_radio_button_new_with_label(group, "round");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (line_joins_value_changed), 
		      pallet);
  gtk_box_pack_start (GTK_BOX (inner_container), button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (button);
  pallet->joins_button[round_joins] = button;

  group = gtk_radio_button_group (GTK_RADIO_BUTTON(button));
  button = gtk_radio_button_new_with_label(group, "beveled");
  gtk_signal_connect (GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC (line_joins_value_changed), 
		      (gpointer)pallet);
  gtk_box_pack_start (GTK_BOX (inner_container), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  pallet->joins_button[beveled_joins] = button;
  
  // gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
  
  return frame;
}
static void
line_joins_value_changed (GtkWidget *widget, gpointer data)
{
  PaintStylePallet * pallet = (PaintStylePallet * )data;
  enum ps_line_join joins;
  if (pallet->joins_button[mitered_joins] == widget)
    {
      joins = mitered_joins;
    }
  else if (pallet->joins_button[round_joins] == widget)
    {
      joins = round_joins;
    }
  else if (pallet->joins_button[beveled_joins] == widget)
    {
      joins = beveled_joins;
    }
  else
    assert(0);

  if ([[Gyve application] mode] == GUI_interactive_mode)
    [pallet setLineJoin: joins];
}

static GtkWidget *
line_caps_frame_new (PaintStylePallet * pallet)
{
  GtkWidget * frame;
  GtkWidget * inner_container;
  GtkWidget * button;
  GSList * group;

  frame  = gtk_frame_new ("Line caps");
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  
  inner_container = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (inner_container), 10);
  gtk_container_add (GTK_CONTAINER (frame), inner_container);
  gtk_widget_show (inner_container);
  
  button = gtk_radio_button_new_with_label (NULL, "butt end");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (line_caps_value_changed),
		      pallet);
  gtk_box_pack_start (GTK_BOX (inner_container), button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (button);
  pallet->caps_button[butt_end_caps] = button;

  group  = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
  button = gtk_radio_button_new_with_label(group, "round end");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (line_caps_value_changed), 
		      pallet);
  gtk_box_pack_start (GTK_BOX (inner_container), button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (button);
  pallet->caps_button[round_end_caps] = button;

  group = gtk_radio_button_group (GTK_RADIO_BUTTON(button));
  button = gtk_radio_button_new_with_label(group, "square end");
  gtk_signal_connect (GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC (line_caps_value_changed), 
		      (gpointer)pallet);
  gtk_box_pack_start (GTK_BOX (inner_container), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  pallet->caps_button[square_end_caps] = button;
  
  /* ȤϤȥå */
  // gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
  
  return frame;
}

static void
line_caps_value_changed (GtkWidget *widget, gpointer data)
{
  PaintStylePallet * pallet = (PaintStylePallet * )data;
  enum ps_line_cap caps;
  if (pallet->caps_button[butt_end_caps] == widget)
    {
      caps = butt_end_caps;
    }
  else if (pallet->caps_button[round_end_caps] == widget)
    {
      caps = round_end_caps;
    }
  else if (pallet->caps_button[square_end_caps] == widget)
    {
      caps = square_end_caps;
    }
  else
    assert(0);
  if ([[Gyve application] mode] == GUI_interactive_mode)
    [pallet setLineCap: caps];
}

static GtkWidget *
line_width_frame_new (PaintStylePallet * pallet)
{
  GtkWidget *scrollbar;
  GtkWidget * scale;
  GtkWidget * inner_container;
  GtkWidget * frame = gtk_frame_new ("Line width");
  GtkObject * adjutment;
  gtk_container_border_width (GTK_CONTAINER (frame), 10);

  inner_container = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (inner_container), 10);
  gtk_container_add (GTK_CONTAINER (frame), inner_container);
  gtk_widget_show (inner_container);

  adjutment = gtk_adjustment_new (0.0, 0.0, LINEWIDTH_MAX_FLOAT, 
				  0.1, 1.0, 1.0); // ???
  gtk_adjustment_set_value(GTK_ADJUSTMENT(adjutment), 1.0);
  gtk_signal_connect (GTK_OBJECT (adjutment), "value_changed",
		      (GtkSignalFunc) line_width_value_changed, NULL);
  scale = gtk_hscale_new (GTK_ADJUSTMENT (adjutment));
  gtk_widget_set_usize (GTK_WIDGET (scale), 150, 30);
  gtk_range_set_update_policy (GTK_RANGE (scale), GTK_UPDATE_DELAYED);
  gtk_scale_set_digits (GTK_SCALE (scale), 1);
  gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
  gtk_box_pack_start (GTK_BOX (inner_container), scale, TRUE, TRUE, 0);
  gtk_widget_show (scale);

  scrollbar = gtk_hscrollbar_new (GTK_ADJUSTMENT (adjutment));
  gtk_range_set_update_policy (GTK_RANGE (scrollbar), 
			       GTK_UPDATE_CONTINUOUS);
  gtk_box_pack_start (GTK_BOX (inner_container), scrollbar, TRUE, TRUE, 0);
  gtk_widget_show (scrollbar);  

  pallet->linewidth_adjutment = adjutment;
  
  return frame;
}

static void
line_width_value_changed(GtkAdjustment * adjustment, gpointer data)
{
  // PaintStylePallet * pallet = (PaintStylePallet * )data;
  float width = adjustment->value;
  if ([[Gyve application] mode] == GUI_interactive_mode)
    [[PaintStylePallet paintStylePallet] setLineWidth: width];
}


/* Process Color */
static void process_color_changed(GtkColorSelection *colorsel, void * pallet);

static GtkWidget *
process_color_pallet_new(PaintStylePallet * pallet)
{
  pallet->process_color_pallet = gtk_color_selection_new ();
  gtk_signal_connect (GTK_OBJECT (  pallet->process_color_pallet), 
		      "color_changed",
		      GTK_SIGNAL_FUNC (process_color_changed),
		      pallet);
  return pallet->process_color_pallet;
}
static void
process_color_changed(GtkColorSelection *colorsel, gpointer data)
{
  NSObject * painting;
  PaintStylePallet * pallet = (PaintStylePallet *)data;
  double color[3];
  gtk_color_selection_get_color(colorsel, color);
  painting = [PSProcessColor processColorWithRed: (float)color[0]
			     green:  (float)color[1]
			     blue:  (float)color[2]];
  [pallet setPainting: painting];
}


/* Custom Color */
static void custom_color_changed(
  GtkWidget * widget,
  GdkEventButton * event,
  gpointer data);

static GtkWidget *
custom_color_pallet_new(PaintStylePallet * pallet)
{
  GtkWidget *hbox;
  GtkWidget *win;
  GtkWidget *main_box = gtk_vbox_new (FALSE, 4);

  gtk_container_border_width (GTK_CONTAINER (main_box), 6);
  
  hbox = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (main_box), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  /* scroll window */
  win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (win),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_ALWAYS);
  gtk_signal_connect (GTK_OBJECT (win), "button_press_event",
		      (GtkSignalFunc)custom_color_changed, pallet);
  gtk_box_pack_start (GTK_BOX (hbox), win, TRUE, TRUE, 0);
  gtk_widget_show (win);

  pallet->custom_colors_list_box = gtk_list_new ();
  gtk_list_set_selection_mode (GTK_LIST (pallet->custom_colors_list_box),
			       GTK_SELECTION_BROWSE);
  gtk_container_add (GTK_CONTAINER (win), pallet->custom_colors_list_box);
  gtk_widget_show (pallet->custom_colors_list_box);
  return main_box;
}

static void
custom_color_changed(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
  NSObject * painting;
  PaintStylePallet * pallet = (PaintStylePallet *)data;
  GtkWidget *event_widget;
  char *name;
  float r, g, b;

  event_widget = gtk_get_event_widget ((GdkEvent *) event);
  name 	   = (char *) gtk_object_get_user_data (GTK_OBJECT (event_widget));
  painting = [PSCustomColor customColorWithName:
			      [NSString stringWithCString: name]];
  [pallet setPainting: painting];
}

/* Pattern */
static GtkWidget *
pattern_pallet_new(PaintStylePallet * pallet)
{
  return gtk_vbox_new(FALSE, 10);
}
  
/* Gradation */
static GtkWidget *
gradation_pallet_new(PaintStylePallet * pallet)
{
  return gtk_vbox_new(FALSE, 10);
}
