/* painting_preview.h

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by: Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef PAINTING_PREVIEW_H
#define PAINTING_PREVIEW_H 

/*
  +-----+ filling
  |     |
  |  +--+--+ stroking
  +--+--+  |
     |     |
     +-----+ */

@class GyveCanvas;
#include <Foundation/NSGeometry.h>
#include <DPS/dpsfriends.h>
#include <DPS/dpsXuserpath.h>
#include <gtk/gtk.h>

struct painting_preview
{
  GyveCanvas * filling_canvas;
  GyveCanvas * stroking_canvas;
  BOOL is_filling_active;
  void (*preview_switch_relay)(GyveCanvas * canvas, DPSUserPathAction action);
};
GtkWidget * painting_preview_new(struct painting_preview * preview);
void painting_preview_set_relay(struct painting_preview * preview, 
				void (*relay)(GyveCanvas * canvas, 
				       DPSUserPathAction action));
DPSUserPathAction painting_preview_get_active(struct painting_preview * preview);
void painting_preview_switch(struct painting_preview * preview,
			     DPSUserPathAction action);
void painting_preview_set_painting(struct painting_preview * preview,
				   NSObject * painting,
				   DPSUserPathAction action);
void painting_preview_update(struct painting_preview * preview);
#endif /* Not def: PAINTING_PREVIEW_H */
