/* popup_menu.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef POPUP_MENU_H
#define POPUP_MENU_H 
#include <gtk/gtk.h>

GtkWidget *popup_menu_new(GtkMenuEntry * menu_items, 
			  gint nmenu_items,
			  char * entry_name);
void popup_menu_popup(GtkWidget *popup_menu, gint button, guint32 activate_time);

void menu_file_print();
void menu_edit_cut();
void menu_edit_copy();
void menu_edit_paste();
void menu_edit_delete();
void menu_group_create();
void menu_group_release();
void menu_mask_create();
void menu_mask_release();
void menu_compound_paths_create();
void menu_compound_paths_release();
void menu_mode_artwork();
void menu_mode_preview();
void menu_enable_imagecache();
void menu_disable_imagecache();
void menu_image_test_random();
void menu_image_test_xpm();
void menu_text_logo();

#endif /* Not def: POPUP_MENU_H */
