/* popup_menu.m --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "popup_menu.h"
#include "GyveGUI.h"
#include "GyveBuffer.h"
#include "GyveWindow.h"
#include "GyveCanvas.h"
#include "GyveSelectionsLayer.h"
#include "Gyve.h"
#include "PSFigObjGroup.h"
#include "PSMaskedFigObjGroup.h"
#include "PSCompoundPaths.h"
#include "PSImage.h"
#include "GyvePrinter.h"

#include <Foundation/NSString.h>
#include <Foundation/NSDictionary.h>

// Menu functions...

GtkWidget * 
popup_menu_new(GtkMenuEntry * menu_items, gint nmenu_items, char * entry_name)
{
  GtkMenuFactory *menu_factory = gyve_root_menu_factory();
  GtkMenuFactory *menu_subfactory__popup;
  menu_subfactory__popup = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU);
  gtk_menu_factory_add_subfactory (menu_factory,
				   menu_subfactory__popup, entry_name);
  gtk_menu_factory_add_entries (menu_factory, menu_items, nmenu_items);
  return menu_subfactory__popup->widget;
}	    

void 
popup_menu_popup(GtkWidget * popup_menu, gint button, guint32 activate_time)
{
  gtk_menu_popup (GTK_MENU(popup_menu), 
		  NULL, NULL, NULL, NULL, 
		  button, activate_time);
}

/*
 * print
 */
void
menu_file_print()
{
  NSObject<GyvePrinter> * printer;
  printer = [[[GyveEPSPrinter alloc] initWithFilePath: @"/tmp/gyve.eps" 
				    buffer: [GyveBuffer currentBuffer]]
	      autorelease];
  if (nil != printer)
    {
      [printer print];
      gyve_message("Print to /tmp/gyve.eps");
    }
}

/*
 * cut and paste
 */ 
NSString * cut_buffer_key = @"cut_buffer";
void
menu_edit_copy()
{
  gyve_copy_for_key(cut_buffer_key);
}

void
menu_edit_cut()
{
  gyve_cut_for_key(cut_buffer_key);
}
  
void menu_edit_paste()
{
  gyve_paste_for_key(cut_buffer_key);
}

void
menu_edit_delete()
{
  GyveWindow * document_window 	  = [GyveWindow currentWindow];
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  int i, max 		  = [document_buffer countSelectedFigObjs];
  const int current_index = 0;
  PSFigObjSelectedProxy * figobj_proxy;
  PSTextSelectedProxy * text_proxy;
  id <PSText> text;

  [document_window redrawLockRetain];
  if ((max == 1) 
      && ([[document_buffer selectedFigObjAtIndex: 0] 
	   isKindOfClass: [PSTextSelectedProxy class]])
      && [(PSTextSelectedProxy *)[document_buffer selectedFigObjAtIndex: 0]
				 hasSelectionRange])
    {
      text_proxy = (PSTextSelectedProxy *)[document_buffer
					    selectedFigObjAtIndex: 0];
      text  = [text_proxy targetForTextProxy];
      [document_window redrawFigObj: text];
      text = [text_proxy beginModificationByCopy];
      [text_proxy removeTextElements];
      [text_proxy endModification];
      [document_window redrawFigObj: text];
    }
  else
    {
      for (i = 0; i < max; i++)
	{
	  figobj_proxy = [document_buffer selectedFigObjAtIndex: current_index]; 
	  [document_window redrawFigObj: 
			     [(id<PSBBox>)figobj_proxy targetForFigObjProxy]];
	  [figobj_proxy delete];
	}
    }
  [document_window redrawLockRelease];  
}

/*
 * Figobjs manipulation
 */ 
void
menu_group_create()
{
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  GyveWindow * document_window = [GyveWindow currentWindow];
  PSFigObjGroup * group = [[[PSFigObjGroup alloc] init] autorelease];  
  int i, max = [document_buffer countSelectedFigObjs];
  PSFigObjSelectedProxy * figobj_proxy;
  id<PSFigObj> figobj;
  if (max < 1)
    {
      gyve_message("No figure object to be grouped.");
      return ;
    }
  else if (max == 1)
    {
      gyve_message("Too few figobj to create a group.");
      return ;
    }
  for (i = 0; i < max; i++)
    {
      figobj_proxy = [document_buffer selectedFigObjAtIndex: i];
      figobj 	   = [[[figobj_proxy targetForFigObjProxy] copy] autorelease];
      [group addFigObj: figobj];
    }
  [group calcBBox];
  [document_window redrawLockRetain];
  menu_edit_delete();
  [document_buffer putFigObj: group];
  [document_window redrawLockRelease];
}

void
menu_group_release()
{
  GyveBuffer * buffer 	= [GyveBuffer currentBuffer];
  GyveWindow * window 	= [GyveWindow currentWindow];
  GyveLayer * snapshot = [buffer selectionsLayerSnapShot];
  int i, max = [buffer countSelectedFigObjs];
  PSFigObjSelectedProxy * figobj_proxy;
  [window redrawLockRetain];
  for (i = 0; i < max ; i++)
    {
       figobj_proxy = [snapshot figObjAtIndex: i];
       [window redrawFigObj: [figobj_proxy targetForFigObjProxy]];
       [figobj_proxy expand];
    }
  [window redrawLockRelease];
}

void
menu_mask_create()
{
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  GyveWindow * document_window = [GyveWindow currentWindow];
  PSMaskedFigObjGroup * mask;
  int i, max = [document_buffer countSelectedFigObjs];
  PSFigObjSelectedProxy * figobj_proxy;
  id<PSFigObj> figobj;
  if (max < 1)
    {
      gyve_message("No figure object to be a masked object.");
      return ;
    }
  else if (max == 1)
    {
      gyve_message("Too few figobj to create a masked object.");
      return ;
    }
  
  figobj_proxy = [document_buffer selectedFigObjAtIndex: max - 1];
  figobj = [[[figobj_proxy targetForFigObjProxy] copy] autorelease];
  mask = [[[PSMaskedFigObjGroup alloc] initWithMaskPath: figobj]
	   autorelease];
  for (i = 0; i < (max - 1) ; i++)
    {
      figobj_proxy = [document_buffer selectedFigObjAtIndex: i];
      figobj 	   = [[[figobj_proxy targetForFigObjProxy] copy] autorelease];
      [mask addFigObj: figobj];
    }
  
  [mask calcBBox];
  [document_window redrawLockRetain];
  menu_edit_delete();
  [document_buffer putFigObj: mask];
  [document_window redrawLockRelease];
}

void
menu_mask_release()
{
  menu_group_release();
}

void
menu_compound_paths_create()
{
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  GyveWindow * document_window = [GyveWindow currentWindow];
  PSCompoundPaths * cpaths     = [[[PSCompoundPaths alloc] init] autorelease];
  int i, max = [document_buffer countSelectedFigObjs];
  PSFigObjSelectedProxy * figobj_proxy;
  id<PSFigObj> figobj;
  if (max < 1)
    {
      gyve_message("No figure object to be compound paths.");
      return ;
    }
  else if (max == 1)
    {
      gyve_message("Too few figobj to create compound paths.");
      return ;
    }
  for (i = 0; i < max; i++)
    {
      figobj_proxy = [document_buffer selectedFigObjAtIndex: i];
      figobj 	   = [[[figobj_proxy targetForFigObjProxy] copy] autorelease];
      [cpaths addFigObj: figobj];
    }
  [cpaths calcBBox];
  [document_window redrawLockRetain];
  menu_edit_delete();
  [document_buffer putFigObj: cpaths];
  [document_window redrawLockRelease];
}

void
 menu_compound_paths_release()
{
  menu_group_release();
}


void
menu_mode_artwork()
{
  GyveCanvas * canvas = [[GyveWindow currentWindow] contentCanvas];
  [[canvas drawingEngine] setDrawingMode: ARTWORK_MODE];
  [canvas redrawAll];
}
void
menu_mode_preview()
{
  GyveCanvas * canvas = (GyveCanvas *)[[GyveWindow currentWindow] contentCanvas];
  [[canvas drawingEngine] setDrawingMode: PREVIEW_MODE];
  [canvas redrawAll];
}

void
menu_enable_imagecache()
{
  GyveCanvas * canvas = [[GyveWindow currentWindow] contentCanvas];
  [canvas enableImageCache];
}
void
menu_disable_imagecache()
{
  GyveCanvas * canvas = [[GyveWindow currentWindow] contentCanvas];
  [canvas disableImageCache];
}

void
menu_image_test_random()
{
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  GyveWindow * document_window = [GyveWindow currentWindow];
  PSImage * i = [PSImage randomImageWithWidth: 50 height: 50];
  [document_buffer putFigObj: i];
  [document_window redrawFigObj: i];
}

 GtkWidget * xpm_import_dialog_new (GyveWindow * window);
void xpm_import_dialog_select(GtkWidget * dialog, gpointer data);

void
menu_image_test_xpm()
{
  GyveWindow * document_window = [GyveWindow currentWindow];
  
  GtkWidget * xpm_import_dialog = xpm_import_dialog_new(document_window);
  if (NULL != xpm_import_dialog)
    gtk_widget_show(xpm_import_dialog);
}

 GtkWidget *
xpm_import_dialog_new (GyveWindow * window)
{
#ifdef HAVE_LIBXPM
  GtkWidget * dialog = gtk_file_selection_new("Import XPM\n");
  gtk_object_set_data(GTK_OBJECT(dialog), "window", window);

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->ok_button),
		     "clicked", GTK_SIGNAL_FUNC(xpm_import_dialog_select),
		     dialog);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->cancel_button),
		     "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
		     GTK_OBJECT(dialog));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog), ".xpm");
  gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(dialog));
  return dialog;
#else 
  gyve_message("Importing Xpm is not supported.");
  return NULL;
#endif  /* HAVE_LIBXPM */
}

void
xpm_import_dialog_select(GtkWidget * widget, gpointer data)
{
  GtkWidget * dialog = (GtkWidget *)data;
  char * fname 	      = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog));
  PSImage * i 	      = [PSImage imageFromXpmFile: fname];
  if (nil == i)
    {
      gyve_message("Fail to import xpm image\n");
    }
  else
    {
      GyveWindow * window = gtk_object_get_data(GTK_OBJECT(dialog), "window");
      [[window contentBuffer] putFigObj: i];
      [window redrawFigObj: i];
    }
  gtk_widget_destroy(dialog);
}


void menu_text_logo()
{
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  GyveWindow * document_window = [GyveWindow currentWindow];
  NSPoint p 	    = {100.0, 100.0};
  PSTextAtPoint * t = [[[PSTextAtPoint alloc]
			initWithString: @"GNU\nYellow\nVector\nEditor" point: &p]
			autorelease];
  [document_window redrawLockRetain];
  [document_window redrawBBox: [document_buffer selectionsLayer] 
		   expandBy: 2.0];
  [document_buffer unSelectAll];
  [document_buffer putFigObj: t];
  [document_window redrawFigObj: t];  
  [document_window redrawLockRelease];
}
