/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
  PSConsole -- postscirpt console widget
  Author: Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
 */

#ifndef __PSCONSOLE_H__
#define __PSCONSOLE_H__

#include <gtk/gtkwindow.h>
#include <gtk/gtkadjustment.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define PSCONSOLE(obj)          GTK_CHECK_CAST (obj, psconsole_get_type (), PSConsole)
#define PSCONSOLE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, psconsole_get_type (), PSConsoleClass)
#define IS_PSCONSOLE(obj)       GTK_CHECK_TYPE (obj, psconsole_get_type ())

typedef struct _PSConsoleFlush	PSConsoleFlush;
typedef struct _PSConsole	PSConsole;
typedef struct _PSConsoleClass	PSConsoleClass;

struct _PSConsoleFlush
{
  guint	flushing : 1;
  guint flush_pos;
  guint saved_pos;
  guint idle_tag;
  guint timeout_tag;
};

struct _PSConsole
{
  GtkWindow window;

  gchar *prompt;
  GList *history;
  GList *history_current;
  GtkWidget *text;
  GtkWidget *entry;
  GtkAdjustment *vadj;
  PSConsoleFlush flush;
};

struct _PSConsoleClass
{
  GtkWindowClass parent_class;
};

guint psconsole_get_type(void);
GtkWidget *psconsole_new(gchar *prompt, gchar *initial_message);
void psconsole_output(PSConsole *con, gchar *string);

#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* __PSConsole_H__ */



/*
 * Local Variables:
 * Mode: c
 * c-basic-offset: 2
 * End:
 */
