/* text_style_pallet.m

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 
#include "TextStylePallet.h"
#include "text_style_pallet.h"
#include "GyveGUI.h"
#include "GyveBuffer.h"
#include "GyveWindow.h"
#include "Gyve.h"

#include <gtkDPS/gtkDPSfontpanel.h>

static void text_style_pallet_ok_handler (GtkWidget * widget, gpointer data);
static void text_style_pallet_font_change_handler (GtkWidget * widget, gpointer data);

GtkWidget *
text_style_pallet_new(TextStylePallet * pallet)
{
  GtkWidget * font_panel;
  GtkWidget * window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Text Style");
  gtk_signal_connect(GTK_OBJECT(window), "enter_notify_event",
		     GTK_SIGNAL_FUNC (gui_enter_interactive_mode),
		     NULL);
  font_panel = gtk_dps_fontpanel_new();
  gtk_signal_connect_object (GTK_OBJECT (GTK_DPS_FONTPANEL (font_panel)->close_button),
			     "clicked", 
			     GTK_SIGNAL_FUNC (gtk_widget_hide), 
			     GTK_OBJECT(window));
  gtk_signal_connect (GTK_OBJECT (GTK_DPS_FONTPANEL (font_panel)->ok_button),
		      "clicked", 
		      GTK_SIGNAL_FUNC (text_style_pallet_ok_handler), 
		      font_panel);
  gtk_signal_connect (GTK_OBJECT (GTK_DPS_FONTPANEL(font_panel)), "font_changed",
		      GTK_SIGNAL_FUNC (text_style_pallet_font_change_handler), 
		      font_panel);

  gtk_widget_show(font_panel);
  gtk_container_border_width (GTK_CONTAINER (window), 10);
  gtk_container_add (GTK_CONTAINER (window), font_panel);
  return window;
}

static void
text_style_pallet_ok_handler (GtkWidget * widget, gpointer data)
{
  NSPoint p 	    = {100.0, 100.0};
  GyveBuffer * document_buffer = [GyveBuffer currentBuffer];
  GyveWindow * document_window = [GyveWindow currentWindow];
  GtkDPSFontpanel *fontpanel = data;
  char *fontname = (char *) gtk_dps_fontpanel_get_fontname (fontpanel);
  char *input = (char *) gtk_dps_fontpanel_get_input (fontpanel);
  int size = gtk_dps_fontpanel_get_fontsize (fontpanel);
  PSTextAtPoint * t;
  
  if (fontname == NULL)
    {
      fprintf(stderr, "No font name\n");
      return ;
    }

  [[TextStylePallet textStylePallet]
    setFontName: [NSString stringWithCString: fontname]];
  [[TextStylePallet textStylePallet]
    setFontSize: size];
  /* 
  t = [[[PSTextAtPoint alloc]
	initWithString: [NSString stringWithCString: input]
	point: &p] autorelease];
  [document_window redrawLockRetain];
  [document_window redrawBBox: [document_buffer selectionsLayer] expandBy: 1.0];
  [document_buffer unSelectAll];
  [document_buffer putFigObj: t];
  [document_window redrawFigObj: t];  
  [document_window redrawLockRelease]; */
}

static void
text_style_pallet_font_change_handler (GtkWidget * widget, gpointer data)
{
  GtkDPSFontpanel *fontpanel = data;
  char *fontname = (char *) gtk_dps_fontpanel_get_fontname (fontpanel);
  int size = gtk_dps_fontpanel_get_fontsize (fontpanel);
  [[TextStylePallet textStylePallet]
    setFontName: [NSString stringWithCString: fontname]];
  [[TextStylePallet textStylePallet]
    setFontSize: size];
}

