/* toolbox.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Author: Shigeru AOSASA (aozasa@sakuranet.or.jp)
   Modified by: Masatake YAMATO (masata-y@is.aist-nara.ac.jp)
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef TOOLBOX_H
#define TOOLBOX_H 
#include <gtk/gtk.h>
/* <Japanese> 
   $B%D!<%k%\%C%/%9>e$N%\%?%s@8@.MW5a;EMM(B
   </Japanese> */
struct gyveGtkToolButtonSpec {
  /* <Japanese>$B%i%Y%kJ8;zNs(B</Japanese> */
  char * label;			
  /* <Japanese>   "click"$B%7%0%J%k$KBP$9$k%3!<%k%P%C%/4X?t(B, 
     DATA$B$O$3$N9=B$BN$N<!$N%U%#!<%k%I(Bdata$B$G(B
    $B;XDj$7$?$b$N$,EO$5$l$k(B. </Japanese> */
  void (*func)(GtkButton *button, gpointer data); 
  /* <Japanese>$B>e$N%3!<%k%P%C%/$N0z?t$H$7$FM?$($i$l$k%G!<%?(B</Japanese> */
  gpointer data;
  /* <Japanese>$B%&%#%8%'%C%H$=$N$b$N(B</Japanese> */
  GtkWidget *button;
  /* <Japanese>$B%"%$%3%s%G!<%?(B</Japanese> */
  char **icon;
};

GtkWidget * toolbox_new(GtkMenuEntry * menu_items, 
			gint nmenu_items,
			/* <Japanese>$BG[Ns$GM?$($k(B. </Japanese> */
			struct gyveGtkToolButtonSpec * button_specs, 
			/* <Japanese>$BG[Ns$GM?$($?%\%?%s$N;EMM$N8D?t(B. </Japanese> */
			gint nbutton_specs);

#endif /* Not def: TOOLBOX_H */
