/* toolbox.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Author: Shigeru AOSASA (aozasa@sakuranet.or.jp)
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include <gtk/gtk.h>

#include "gtkvfbox.h"
#include "toolbox.h"
#include "GyveGUI.h"

#include  "pixmaps-gimp.h"
 
 static void allocate_colors (GtkWidget *parent);
 static GdkPixmap *create_pixmap (GdkWindow *parent, GdkBitmap **mask,
 				 char **data, int width, int height);
 static GtkWidget*create_pixmap_widget (GdkWindow *parent,
 				       char **data, int width, int height);
  
 static GdkColor colors[12];
 static int pixmap_colors[8][3] =
 {
   { 0x00, 0x00, 0x00 }, /* a - 0   */
   { 0x24, 0x24, 0x24 }, /* b - 36  */
   { 0x49, 0x49, 0x49 }, /* c - 73  */
   { 0x6D, 0x6D, 0x6D }, /* d - 109 */
   { 0x92, 0x92, 0x92 }, /* e - 146 */
   { 0xB6, 0xB6, 0xB6 }, /* f - 182 */
   { 0xDB, 0xDB, 0xDB }, /* g - 219 */
   { 0xFF, 0xFF, 0xFF }, /* h - 255 */
 };

GtkWidget *
toolbox_new(GtkMenuEntry * menu_items, gint nmenu_items,
	       struct gyveGtkToolButtonSpec * button_specs, gint nbutton_specs)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *menu;
  GtkWidget *vfbox;
  GtkWidget *rbox;
  GtkWidget *label;
  GtkWidget *pixmap;
  GtkMenuFactory *menu_factory = gyve_root_menu_factory();
  GtkMenuFactory *menu_subfactory__toolbox;
  gint i;
  gint old_mask;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
 		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

  /* Added mode switch */
  old_mask = gtk_widget_get_events(GTK_WIDGET(window));
  gtk_widget_set_events(GTK_WIDGET(window), old_mask| GDK_ENTER_NOTIFY_MASK);
  gtk_signal_connect(GTK_OBJECT(window), "enter_notify_event",
		     GTK_SIGNAL_FUNC (gui_enter_interactive_mode),
		     NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  allocate_colors (window);

  menu_subfactory__toolbox = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU_BAR);
  gtk_menu_factory_add_subfactory (menu_factory,
				   menu_subfactory__toolbox, "<Toolbox>");

  gtk_menu_factory_add_entries (menu_factory, menu_items, nmenu_items);
  menu = menu_subfactory__toolbox->widget;
  gtk_box_pack_start (GTK_BOX (vbox), menu, FALSE, FALSE, 0);

  vfbox = gtk_vfold_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), vfbox, TRUE, TRUE, 0);

  for (i = 0; i < nbutton_specs; ++i)
    {
      if (i == 0)
	{
	  button_specs[i].button
	      = gtk_radio_button_new(NULL);
	}
      else
	{
	  button_specs[i].button
	      = gtk_radio_button_new(gtk_radio_button_group
 		        (GTK_RADIO_BUTTON (button_specs[0].button)));
	}
      gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (button_specs[i].button),
				  FALSE);
      gtk_widget_set_usize (GTK_WIDGET (button_specs[i].button), 80, 40);
      gtk_box_pack_start_defaults (GTK_BOX (vfbox), button_specs[i].button);
      gtk_signal_connect (GTK_OBJECT (button_specs[i].button),
			  "clicked", 
			  (GtkSignalFunc)button_specs[i].func, 
			  button_specs[i].data);
      rbox = gtk_vbox_new(FALSE, 0);
      gtk_container_add (GTK_CONTAINER (button_specs[i].button), rbox);
 
      label = gtk_label_new(button_specs[i].label);
      gtk_box_pack_end(GTK_BOX (rbox), label, FALSE, FALSE, 0);
 
      if (button_specs[i].icon)
	{
 	  pixmap = create_pixmap_widget (window->window, button_specs[i].icon, 22,22);
 	  gtk_box_pack_start(GTK_BOX (rbox), pixmap, FALSE, FALSE, 0);
 	}
     }
  gtk_widget_set_usize(window, 160+1, (21*nbutton_specs)+12);
  gtk_widget_show_all (window);
  gtk_window_set_title(GTK_WINDOW(window), "The GYVE");
  return window;
}

static void
allocate_colors (GtkWidget *parent)
{
  GdkColormap *colormap;
  int i;

  gtk_widget_realize (parent);
  colormap = gdk_window_get_colormap (parent->window);

  for (i = 0; i < 8; i++)
    {
      colors[i].red = pixmap_colors[i][0] << 8;
      colors[i].green = pixmap_colors[i][1] << 8;
      colors[i].blue = pixmap_colors[i][2] << 8;

      gdk_color_alloc (colormap, &colors[i]);
    }

  colors[8] = parent->style->bg[GTK_STATE_NORMAL];
  gdk_color_alloc (colormap, &colors[8]);

  colors[9] = parent->style->bg[GTK_STATE_ACTIVE];
  gdk_color_alloc (colormap, &colors[9]);

  colors[10] = parent->style->bg[GTK_STATE_PRELIGHT];
  gdk_color_alloc (colormap, &colors[10]);

  /* postit yellow (khaki) as background for tooltips */
  colors[11].red = 61669;
  colors[11].green = 59113;
  colors[11].blue = 35979;
  gdk_color_alloc (colormap, &colors[11]);
}

static GdkPixmap *
create_pixmap (GdkWindow *parent, GdkBitmap **mask,
               char **data, int width, int height)
{
  GdkPixmap *pixmap;
  GdkImage *image;
  GdkGC *gc;
  GdkVisual *visual;
  GdkColormap *cmap;
  gint r, s, t, cnt;
  guchar *mem;
  guchar value;
  guint32 pixel;

  visual = gdk_window_get_visual (parent);
  cmap = gdk_window_get_colormap (parent);
  image = gdk_image_new (GDK_IMAGE_NORMAL, visual, width, height);
  pixmap = gdk_pixmap_new (parent, width, height, -1);
  gc = NULL;

  if (mask)
    {
      GdkColor tmp_color;

      *mask = gdk_pixmap_new (parent, width, height, 1);
      gc = gdk_gc_new (*mask);
      gdk_draw_rectangle (*mask, gc, TRUE, 0, 0, -1, -1);

      tmp_color.pixel = 1;
      gdk_gc_set_foreground (gc, &tmp_color);
    }

 for (r = 0; r < height; r++)
    {
      mem = image->mem;
      mem += image->bpl * r;

      for (s = 0, cnt = 0; s < width; s++)
        {
          value = data[r][s];

          if (value == '.')
            {
              pixel = colors[8].pixel;

              if (mask)
                {
                  if (cnt < s)
                    gdk_draw_line (*mask, gc, cnt, r, s - 1, r);
                  cnt = s + 1;
                }
            }
          else
            {
              pixel = colors[value - 'a'].pixel;
            }

          if (image->byte_order == GDK_LSB_FIRST)
            {
              for (t = 0; t < image->bpp; t++)
                *mem++ = (unsigned char) ((pixel >> (t * 8)) & 0xFF);
            }
          else
            {
              for (t = 0; t < image->bpp; t++)
                *mem++ = (unsigned char) ((pixel >> ((image->bpp - t - 1) * 8)) & 0xFF);
            }
        }

      if (mask && (cnt < s))
        gdk_draw_line (*mask, gc, cnt, r, s - 1, r);
    }

  if (mask)
    gdk_gc_destroy (gc);

  gc = gdk_gc_new (parent);
  gdk_draw_image (pixmap, gc, image, 0, 0, 0, 0, width, height);
  gdk_gc_destroy (gc);
  gdk_image_destroy (image);

  return pixmap;
}

static GtkWidget*
create_pixmap_widget (GdkWindow *parent,
                      char **data, int width, int height)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  pixmap = create_pixmap (parent, &mask, data, width, height);

  return gtk_pixmap_new (pixmap, mask);
}
 
