/* utilities.h --- Some useful functions, macros and data tyeps

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef UTILITIES_H
#define UTILITIES_H 

#include <gyve/constant.h>
#include <objc/objc-api.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSConcreteValue.h>
#include <DPS/dpsfriends.h>
#include <DPS/dpsXuserpath.h>
#include <gtk/gtk.h>
#include <Foundation/NSRange.h>

#define BYREF 
#define BYCOPY 

BOOL streq(char * a, char * b);
BOOL float_zero(float x);

/*
 * FLOATS 
 */
struct floats_data
{
  float * data;
  int length;
};
void floats_data_init(struct floats_data * mem);
BOOL floats_data_realloc(struct floats_data * mem, int length); 
BOOL floats_data_expand(struct floats_data * mem, int length); 
void floats_data_free(struct floats_data * mem);

/*
 * INTS
 */
struct ints_data
{
  int * data;
  int length;
};
void ints_data_init(struct ints_data * mem);
BOOL ints_data_realloc(struct ints_data * mem, int length); 
BOOL ints_data_expand(struct ints_data * mem, int length); 
void ints_data_free(struct ints_data * mem);

/*
 * CHARS
 */
struct chars_data
{
  char * data;
  int length;
};
void chars_data_init(struct chars_data * mem);
BOOL chars_data_realloc(struct chars_data * mem, int length); 
BOOL chars_data_expand(struct chars_data * mem, int length); 
void chars_data_free(struct chars_data * mem);

/*
 * DPSUserPathOps
 */
struct DPSUserPathOps_data
{
  DPSUserPathOp * data;
  int length;
};
void DPSUserPathOps_data_init (struct DPSUserPathOps_data * mem);
BOOL DPSUserPathOps_data_realloc(struct DPSUserPathOps_data * mem, int length);
BOOL DPSUserPathOps_data_expand(struct DPSUserPathOps_data * mem, int length); 
void DPSUserPathOps_data_free(struct DPSUserPathOps_data * mem);

/*
 * RING COUNTER
 */
struct ring_counter
{
  int max;
  int current;
};
void ring_counter_init(struct ring_counter * counter, int max);
void ring_counter_inc(struct ring_counter * counter);
void ring_counter_clear(struct ring_counter * counter);
void ring_counter_set_max(struct ring_counter * counter, int new_max);
BOOL ring_counter_is_striking(struct ring_counter * counter);

/*
 * NSRange
 */
float NSRange_round_by_range(NSRange * range, float target);
NSRange NSRange_from_locations(unsigned int a, unsigned int b);
void NSRange_copy(NSRange * src, NSRange * dist);

/*
 * PointValue extension
 */ 
/* TODO: Implement NSMutablePointValue instead this category */
@interface NSPointValue(Gyve)
- (void)setPointValueX: (float)x;
- (void)setPointValueY: (float)y;
- (void)setPointValueX: (float)x Y: (float)y;
@end

@interface NSValue(Guile)
+ (NSValue*) valueWithPointByX:(float)x Y:(float)y;
+ (NSValue*) valueWithRectByX:(float)x Y: (float)y 
		     width: (float)w height: (float)h;
- (float)pointValueX;
- (float)pointValueY;

- (float)rectValueX;
- (float)rectValueY;
- (float)rectValueWidth;
- (float)rectValueHeight;
@end

/*
 * [[object retain] autorelease];
 */
@interface NSObject(Gyve)
- shallowretain;
@end

/*
 *
 */
#define ASSGIN_NSOBJECT(NEWOBJECT, OLDOBJECT) \
{                                             \
  if (NEWOBJECT != OLDOBJECT)                 \
    {                                         \
      if (nil != NEWOBJECT)                   \
	[NEWOBJECT retain];                   \
      if (nil != OLDOBJECT)                   \
	[OLDOBJECT release];                  \
      OLDOBJECT = NEWOBJECT;                  \
    }                                         \
}                                             

/*
 *
 */
#include <base/Array.h>
#define FOR_ARRAY_REVERSE(ARRAY, ELEMENT_VAR)                          \
{                                                                      \
  unsigned _FOR_ARRAY_i;                                               \
  for (_FOR_ARRAY_i = (((Array*)ARRAY)->_count);                       \
       _FOR_ARRAY_i > 0;                                               \
       _FOR_ARRAY_i--)                                                 \
    {                                                                  \
      ELEMENT_VAR =                                                    \
	(((Array*)ARRAY)->_contents_array[(_FOR_ARRAY_i - 1)]);
/// END_FOR

#define FOR_ARRAY_WITH_MODIFICATION(ARRAY, ELEMENT_VAR)                \
{                                                                      \
  Array * _FOR_ARRAY_id = [[ARRAY shallowCopy] autorelease];           \
  unsigned _FOR_ARRAY_i;                                               \
  for (_FOR_ARRAY_i = 0;                                               \
       _FOR_ARRAY_i < (((Array*)_FOR_ARRAY_id)->_count);               \
       _FOR_ARRAY_i++)                                                 \
    {                                                                  \
      ELEMENT_VAR =                                                    \
	(((Array*)_FOR_ARRAY_id)->_contents_array[_FOR_ARRAY_i]);
/// END_FOR
   
#define FOR_ARRAY_REVERSE_WITH_MODIFICATION(ARRAY, ELEMENT_VAR)        \
{                                                                      \
  Array * _FOR_ARRAY_id = [[ARRAY shallowCopy] autorelease];           \
  unsigned _FOR_ARRAY_i;                                               \
  for (_FOR_ARRAY_i = (((Array*)_FOR_ARRAY_id)->_count);               \
       _FOR_ARRAY_i > 0;                                               \
       _FOR_ARRAY_i--)                                                 \
    {                                                                  \
      ELEMENT_VAR =                                                    \
	(((Array*)_FOR_ARRAY_id)->_contents_array[(_FOR_ARRAY_i - 1)]);
/// END_FOR

/*
 * 
 */
typedef BOOL id_predicator_t(id);
BOOL id_predicator_yes (id);
/* return YES if it is not locked. */
BOOL id_predicator_not_locked (id);
BOOL id_predicator_not_writable (id);
BOOL id_predicator_no (id);
BOOL id_predicator_primitive_figobj(id);
BOOL id_predicator_text(id);

/*
 * ObjC Runtime extensions
 */
// ...
#include<objc/Protocol.h>

Protocol * protocol(char * name);
@interface Protocol (Gyve)
+ (Protocol *)protocolByName:(char *)name;
@end

#define GYVE_SHOULD_NOT_IMPLEMENT(RETURN_FORM) \
        [self shouldNotImplement:_cmd]; \
        RETURN_FORM;
#define GYVE_SUBCLASS_RESPONSIBILITY(RETURN_FORM) \
        [self subclassResponsibility:_cmd];  \
        RETURN_FORM;

#include <Foundation/NSGArray.h>
@interface NSGMutableArray(Gyve)
- (void) prependObject: newObject;
- (void) appendObject: newObject;
- shallowCopy;
@end

@interface GyveStack: NSGMutableArray
- (void) pushObject: anObject;
- popObject;
- topObject;
- (void) duplicateTop;
- (void) exchangeTop;
@end
#endif /* Not def: UTILITIES_H */
