/* utilities.m --- Some useful functions and data tyeps

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "utilities.h"
#include "PSBBox.h"
#include "GyveLayer.h"
#include "PSFigObj.h"
#include "PSText.h"
#include "Gyve.h"
#include "GyveWindow.h"
#include "GyveBuffer.h"
#include <math.h>

#include <Foundation/NSArray.h>
#include <Foundation/NSNotification.h>
@class PSPath, PSImage;

/*
 * FLAOTS 
 */
void
floats_data_init(struct floats_data * mem)
{
  mem->data = NULL;
  mem->length = 0;
}

BOOL
floats_data_realloc(struct floats_data * mem, int length)
{
  float * tmp = objc_realloc(mem->data, sizeof(float)* length);
  if (tmp)
    {
      mem->data = tmp;
      mem->length = length;
      return YES;
    }
  else
    return NO;
}

BOOL 
floats_data_expand(struct floats_data * mem, int length)
{
  if (mem->length >= length)
    return NO;
  else
    {
      floats_data_realloc(mem, length);
      return YES;
    }
}
void 
floats_data_free(struct floats_data * mem)
{
  objc_free(mem->data);
  floats_data_init(mem);
}

/*
 * INTS_DATA
 */

void
ints_data_init(struct ints_data * mem)
{
  mem->data = NULL;
  mem->length = 0;
}

BOOL
ints_data_realloc(struct ints_data * mem, int length)
{
  void * tmp;
  if (mem->data)
    tmp = objc_realloc(mem->data, sizeof(int) * length);
  else
    tmp = objc_malloc(sizeof(int) * length);
  
  if (tmp)
    {
      mem->data = tmp;
      mem->length = length;
      return YES;
    }
  else
    return NO;
}
BOOL 
ints_data_expand(struct ints_data * mem, int length)
{
  if (mem->length >= length)
    return NO;
  else
    {
      ints_data_realloc(mem, length);
      return YES;
    }
}
void 
ints_data_free(struct ints_data * mem)
{
  objc_free(mem->data);
  ints_data_init(mem);
}

/*
 * CHARS_DATA
 */

void
chars_data_init(struct chars_data * mem)
{
  mem->data = NULL;
  mem->length = 0;
}

BOOL
chars_data_realloc(struct chars_data * mem, int length)
{
  void * tmp;
  if (mem->data)
    tmp = objc_realloc(mem->data, sizeof(char) * length);
  else
    tmp = objc_malloc(sizeof(char) * length);
  
  if (tmp)
    {
      mem->data = tmp;
      mem->length = length;
      return YES;
    }
  else
    return NO;
}

BOOL 
chars_data_expand(struct chars_data * mem, int length)
{
  if (mem->length >= length)
    return NO;
  else
    {
      chars_data_realloc(mem, length);
      return YES;
    }
}
void 
chars_data_free(struct chars_data * mem)
{
  objc_free(mem->data);
  chars_data_init(mem);
}

/*
 * DPSUserPathOps
 */

void
DPSUserPathOps_data_init(struct DPSUserPathOps_data * mem)
{
  mem->data = NULL;
  mem->length = 0;
}

BOOL
DPSUserPathOps_data_realloc(struct DPSUserPathOps_data * mem, int length)
{
  void * tmp;
  if (mem->data)
    tmp = objc_realloc(mem->data, sizeof(DPSUserPathOp) * length);
  else
    tmp = objc_malloc(sizeof(DPSUserPathOp) * length);
  
  if (tmp)
    {
      mem->data = tmp;
      mem->length = length;
      return YES;
    }
  else
    return NO;
}
BOOL 
DPSUserPathOps_data_expand(struct DPSUserPathOps_data * mem, int length)
{
  if (mem->length >= length)
    return NO;
  else
    {
      DPSUserPathOps_data_realloc(mem, length);
      return YES;
    }
}
void 
DPSUserPathOps_data_free(struct DPSUserPathOps_data * mem)
{
  objc_free(mem->data);
  DPSUserPathOps_data_init(mem);
}

/*
 * RING COUNTER
 */
void
ring_counter_init(struct ring_counter * counter, int max)
{
  ring_counter_set_max(counter, max);
  ring_counter_clear(counter);
}

void
ring_counter_inc(struct ring_counter * counter)
{
  counter->current++;
  if (counter->current == counter->max)
    ring_counter_clear(counter);
}

void
 ring_counter_clear(struct ring_counter * counter)
{
  counter->current = 0;
}

void
ring_counter_set_max(struct ring_counter * counter, int new_max)
{
  counter->max = new_max;
}

BOOL
ring_counter_is_striking(struct ring_counter * counter)
{
  return (counter->current == 0)? YES: NO;
}


float
NSRange_round_by_range(NSRange * range, float target)
{
  if (range->location > target)
    return range->location;
  else if ((range->location+range->length) < target)
    return (range->location+range->length);
  else
    return target;
}

NSRange
NSRange_from_locations(unsigned int a, unsigned int b)
{
  NSRange result;
  if (a < b)
    {
      result.location = a;
      result.length    = b - a + 1;
    }
  else 
    {
      result.location = b;
      result.length    = a - b + 1;
    }
  return result;
}
  
void
NSRange_copy(NSRange * src, NSRange * dist)
{
  if (src  == NULL ||
      dist == NULL)
    {
      return ;
    }
  else
    {
      dist->location = src->location;
      dist->length  = src->length;
    }
}

 /* PointValue extension */
@implementation NSPointValue(Gyve)
- (void)setPointValueX: (float)x
{
  data.x = x;
}
- (void)setPointValueY: (float)y
{
  data.y = y;
}
- (void)setPointValueX: (float)x Y: (float)y
{
  data.x = x;
  data.y = y;
}
@end

@implementation NSValue(Guile)
+ (NSValue*) valueWithPointByX:(float)x Y:(float)y
{
  NSPoint point;
  point.x = x;
  point.y = y;
  return [self valueWithPoint: point];
}
+ (NSValue*) valueWithRectByX:(float)x Y: (float)y 
		     width: (float)w height: (float)h
{
  NSRect rect;
  rect.origin.x = x;
  rect.origin.y = y;
  rect.size.width = w;
  rect.size.height = h;
  return [self valueWithRect: rect];
}
+ (NSValue *)valueWithBBox: (struct bbox *)b
{
  return [[[PSBBox alloc] initWithBBox: b] autorelease];
}
- (float) pointValueX
{
  return [self pointValue].x;
}
- (float) pointValueY
{
  return [self pointValue].y;
}
- (float)rectValueX
{
  return [self rectValue].origin.x;
}
- (float)rectValueY
{
  return [self rectValue].origin.y;
}
- (float)rectValueWidth
{
  return [self rectValue].size.width;
}
- (float)rectValueHeight
{
 return [self rectValue].size.height; 
}
@end

@implementation NSObject(Gyve)
- shallowretain
{
  [[self retain] autorelease];
  return self;
}
@end

BOOL
streq(char * a, char * b)
{
  return strcmp(a, b)? NO: YES;
}

BOOL
float_zero(float x)
{
  if (x == 0.0 
      || ((x < FLT_EPSILON) && (x > -FLT_EPSILON)))
    {
      return YES;
    }
  else
    {
      return NO;
    }
}
BOOL
id_predicator_yes (id x)
{
  return YES;
}

BOOL
id_predicator_no (id x)
{
  return  NO;
}

BOOL 
id_predicator_not_locked (id x)
{
  if (YES == [x conformsToProtocol: @protocol (PSFigObj)])
    {
      return [(id<PSFigObj>)x isLockedFigObj]? NO: YES;
    }
  else
    return YES;			// ???
}

BOOL
id_predicator_not_writable (id x)
{
  if ([x isKindOfClass: [GyveLayer class]])
    return [(GyveLayer *)x isWritable]? NO: YES;
  else
    return YES;			// ???
}


BOOL
id_predicator_primitive_figobj(id x)
{
  if (NO == [x conformsToProtocol:@protocol (PSFigObj)]) 
    return NO;
  if ([x isKindOfClass: [PSPath class]] ||
      [x isKindOfClass: [PSImage class]] ||
      [x conformsToProtocol: @protocol (PSText)])
    return YES;
  else
    return NO;
}

BOOL
id_predicator_text(id x)
{
  if (x == nil)
    {
      return NO;
    }
  else if (YES == [x conformsToProtocol: @protocol (PSText)])
    {
      return YES;
    }
  else if (YES == id_predicator_primitive_figobj(x))
    {
      return NO;
    }
  else 
    {
      return YES;
    }
}

Protocol *
protocol(char * name)
{
  return [Protocol protocolByName: name];
}
  
@implementation Protocol (Gyve)
+ (Protocol *)protocolByName:(char *)name
{
  return nil;
}
@end

@implementation NSMutableArray(Gyve)
- (void) prependObject: newObject
{
  [self insertObject: newObject atIndex: 0];
}
- (void) appendObject: newObject
{
  [self addObject: newObject];
}
- shallowCopy
{
  return [self mutableCopy];
}
@end

@implementation GyveStack
- (void) pushObject: anObject
{
  [self appendObject: anObject];
}
- popObject
{
  id ret;
  ret = [[self lastObject] retain];
  [self removeLastObject];
  return [ret autorelease];
}
- topObject
{
  return [self lastObject];
}
- (void) duplicateTop
{
  [self pushObject: [self topObject]];
}
- (void) exchangeTop
{
  int count 	   = [self count];
  int top_index    = count -1;
  id top    	   = [self topObject];
  int second_index = count -2;
  id second = [self objectAtIndex: count - 2];
  [self replaceObjectAtIndex: top_index withObject: second]; 
  [self replaceObjectAtIndex: second_index withObject: top]; 
}
@end
