dnl path_dps.m4 --- test for dps client libraries/headers
dnl Copyright (C) 1998 GYVE Development Team
dnl 
dnl Author: Masatake YAMATO (masata-y@is.aist-nara.ac.jp)
dnl
dnl Tested by: Hideki Fujimoto (hideki70@osk2.3web.ne.jp) on Linux.
dnl            Shin-ichi Okada (s-okada@ksd.co.jp) on DGS-Debian.
dnl            Yasuhiro Shirasaki (yasuhiro@awa.tohoku.ac.jp) on OSF1.
dnl            Masatake YAMATO (masata-y@is.aist-nara.ac.jp) on Solaris2, OSF1
dnl
dnl 
dnl Created: Sat Jan 17 14:27:37 1998
dnl Time-stamp: <98/02/04 20:04:27 masata-y>
dnl
dnl path_dps.m4 Version: 10
dnl 
dnl This file is a spinoff of the GYVE vector based drawing editor.  
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl As a special exception, the Free Software Foundation gives unlimited
dnl permission to copy, distribute and modify the configure scripts that
dnl are the output of Autoconf.  You need not follow the terms of the GNU
dnl General Public License when using or distributing such scripts, even
dnl though portions of the text of Autoconf appear in them.  The GNU
dnl General Public License (GPL) does govern all other use of the material
dnl that constitutes the Autoconf program.
dnl
dnl Certain portions of the Autoconf source text are designed to be copied
dnl (in certain cases, depending on the input) into the output of
dnl Autoconf.  We call these the "data" portions.  The rest of the Autoconf
dnl source text consists of comments plus executable code that decides which
dnl of the data portions to output in any given case.  We call these
dnl comments and executable code the "non-data" portions.  Autoconf never
dnl copies any of the non-data portions into its output.
dnl
dnl This special exception to the GPL applies to versions of Autoconf
dnl released by the Free Software Foundation.  When you make and
dnl distribute a modified version of Autoconf, you may extend this special
dnl exception to the GPL to apply to your modified version as well, *unless*
dnl your modified version has the potential to copy into its output some
dnl of the text that was the non-data portion of the version that you started
dnl with.  (In other words, unless your change moves or copies text from
dnl the non-data portions to the data portions.)  If your modification has
dnl such potential, you must delete any notice of this special exception
dnl to the GPL from your modified version.

dnl 
dnl ----------------------------------------------------------------
dnl * Description *
dnl ----------------------------------------------------------------
dnl This file contains three m4 macros, AC_PATH_DPS, AC_CHECK_DPS_NXAGENT
dnl AC_PATH_DPSET, AC_PROG_PSWRAP.
dnl 
dnl AC_PATH_DPS finds paths for the DPS client libraries and headers. 
dnl AC_CHECK_DPS_NXAGENT checks a dps nxagent is available or not.
dnl AC_APTH_DPSET invokes above two macros. Additionally this macro
dnl defines some variables. AC_PROG_PSWRAP checks a existence of 
dnl pswrap translator.
dnl 
dnl
dnl 1. AC_PATH_DPS sets three shell variables, no_dps, dps_includes and 
dnl dps_libraries. 
dnl 
dnl * no_dps
dnl NULL string or "yes" is set. "yes" is set when AC_PATH_DPS cannot find
dnl the path for the DPS releated files or when "no" is specified as the
dnl argument for the option --with-dps of configure script. If AC_PATH_DPS
dnl can find the path, NULL string is set.
dnl
dnl * dps_includes
dnl The path for headers of dps client libraries is set to this variable.
dnl If --with-dps-includes=DIR are given as the flag for configure script,
dnl DIR is set to the variable.
dnl The value does not make sense when the value of no_dps is "yes".
dnl Pass the value to the C compiler through CPPFLAGS in your configure.in 
dnl and you can include DPS header files in your files.
dnl 
dnl NOTE: Strictly the DPS headers are in $dps_includes/DPS.
dnl       So you need to write cpp include directives like:
dnl       #include <DPS/dpsXclient.h>
dnl 
dnl       Don't write like:
dnl       #include <dpsXclient.h>
dnl       
dnl * dps_libraries 
dnl The path for dps client libraries is set to this variable.
dnl If --with-dps-libraries=DIR are given as the flag for configure script,
dnl DIR is set to the variable.
dnl The value does not make sense when the value of no_dps is "yes".
dnl Pass the value to the C compiler(or the linker) through LIBS in your
dnl configure.in and you can link the libdps.a, the DPS client libdps  with 
dnl your program.
dnl e.g.
dnl LIBS="-L$dps_libraries -ldps -$LIBS"
dnl NOTE: Don't forget to add the flags for X libraries to LIBS, too.
dnl 
dnl
dnl 2. AC_CHECK_DPS_NXAGENT checks the existence of the header file <DPS/dpsNXargs.h>
dnl and the function XDPSNXSetClientArg using AC_CHECK_HEADERS and AC_CHECK_FUNCS.
dnl So this macro defines HAVE_DPS_DPSNXARGS_H and HAVE_XDPSNXSETCLIENTARG that can
dnl be be referred from source files of your program if the header and function are
dnl existing.  
dnl For configure.in programmer, this macros defines three shell
dnl variables, no_dps_nxagent_header and no_dps_nxagent_func and no_dps_nxagent.
dnl
dnl * no_dps_nxagent_header
dnl NULL string or yes is set. yes is set if the header file is not existing.
dnl
dnl * no_dps_nxagent_func
dnl NULL string or yes is set. yes is set if the function is not existing.
dnl 
dnl * no_dps_nxagent
dnl NULL string or yes is set. yet is set if yet is set to no_dps_nxagent_header nor 
dnl no_dps_nxagent_func.
dnl
dnl
dnl 3. AC_PATH_DPSET is extended version of AC_PATH_DPS and AC_CHECK_DPS_NXAGENT.
dnl AC_PATH_DPSET sets no_dps, dps_includes, dps_libraries no_dps_nxagent_header,
dnl no_dps_nxagent_func and no_dps_nxagent which are explained 
dnl above. Additionally it sets DPS_CFLAGS, DPS_LIBS when no_dps is set to a NULL
dnl string like:
dnl DPS_CFLAGS=-I${dps_includes}
dnl DPS_LIBS="-L${dps_libraries} -ldpstk -ldps"
dnl It also defines HAVE_DPS_NXAGENT that will be passed to the C compiler if
dnl NULL string is set to no_dps_nxagent.
dnl
dnl Use AC_PATH_DPSET in your configure.in and C source files like this:
dnl --- configure.in ---
dnl AC_PATH_XTRA
dnl AC_PATH_DPSET
dnl if test "x$no_dps" = xyes ; then
dnl 	AC_MSG_ERROR(Could not find the dps client library: see config.log)
dnl fi
dnl CPPFLAGS="$CPPFLAGS $DPS_CFLAGS $X_CFLAGS"
dnl LIBS="$LIBS $DPS_LIBS $X_PRE_LIBS $X_LIBS -lXext -lX11 -lm $X_EXTRA_LIBS"
dnl --- C source file ---
dnl #ifdef HAVE_DPX_NXAGENT    
dnl #include <DPS/dpsNXargs.h>
dnl #endif
dnl ...
dnl #if HAVE_DPX_NXAGENT    
dnl   fprintf(stderr, "Does X server supports DPS extension...");
dnl   XDPSNXSetClientArg(XDPSNX_AUTO_LAUNCH, (void *)True);
dnl #endif
dnl ...
dnl --- end ---
dnl
dnl 4. AC_PROG_PSWRAP checks the existence of the command `pswrap'.
dnl pswrap is also part of DPS client library. 
dnl If the command exists, AC_PROG_PSWRAP set PSWRAP to "pswrap".
dnl Otherwise AC_PROG_PSWRAP set PSWRAP to "", an empty string.
dnl
dnl
dnl 5. How to mix this file with your package
dnl You need to include path_dps.m4 in your package.
dnl * If you use automake and  if you didn't install path_dps.m4
dnl   [1] Create a file named acinclude.m4 at the root directory of your package.
dnl   [2] Put follwoing codes in the acinclude.m4
dnl       include(path_dps.m4)
dnl   [3] Add path_dps.m4 to EXTRA_DIST in the Makefile.am at the directory .
dnl   [4] Invoke the follwoing commands at the directory:
dnl       automake; aclocal -I .; autoconf 
dnl
dnl * If you use automake and  if you installed path_dps.m4
dnl   [1] automake; autoconf 
dnl
dnl * If you use autoconf only:
dnl Use aclocal.m4. Read the info of autoconf. I tested path_dps.m4 only with
dnl automake.
dnl 
dnl 6. TODO
dnl * English, checking libdpstk.a

dnl ----------------------------------------------------------------
dnl * private AC_PATH_DPS_GUESS_GNUSTEP(HEADER_or_LIBRARY)
dnl
dnl Guessing the path by the GNUSTEP_SYSTEM_ROOT environment variable.
dnl If the user install dgs using GNUstep make pacakge, the the client
dnl libraries and headers may be installed at the somewhere under the
dnl $GNUSTEP_SYSTEM_ROOT.
dnl 
dnl This macro takes one argument, HEADER_or_LIBRARY.
dnl 
dnl If HEADER_or_LIBRARY is "HEADER", this macro guesses 
dnl dps headers directory path and set dps_includes_candidates_gstep.
dnl Else this macro guesses dps libraries directory path and 
dnl set dps_libraries_candidates_gstep.
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPS_GUESS_GNUSTEP, 
[dps_arch=${GNUSTEP_HOST_CPU}
dps_os=${GNUSTEP_HOST_OS}
dps_combo=${LIBRARY_COMBO}
#
if test x$1 = "xHEADER" ; then
	dps_includes_candidates_gstep="${GNUSTEP_SYSTEM_ROOT}/Headers ${GNUSTEP_SYSTEM_ROOT}/Headers/${dps_arch}/${dps_os}"
else	
	if test x$dps_combo = "x"; then
		dps_libraries_candidates_gstep=${GNUSTEP_SYSTEM_ROOT}/Libraries/${dps_arch}/${dps_os}
	elif test -r "${GNUSTEP_SYSTEM_ROOT}/Libraries/${dps_arch}/${dps_os}/libdps.a"; then
		dps_libraries_candidates_gstep=${GNUSTEP_SYSTEM_ROOT}/Libraries/${dps_arch}/${dps_os}
	elif test -r "${GNUSTEP_SYSTEM_ROOT}/Libraries/${dps_arch}/${dps_os}/libdps.so"; then
		dps_libraries_candidates_gstep=${GNUSTEP_SYSTEM_ROOT}/Libraries/${dps_arch}/${dps_os}
	else
		dps_libraries_candidates_gstep=${GNUSTEP_SYSTEM_ROOT}/Libraries/${dps_arch}/${dps_os}/${dps_combo}
	fi
fi
no_dps=
])

dnl ----------------------------------------------------------------
dnl * private AC_PATH_DPS_GUESS(HEADER_or_LIBRARY)
dnl 
dnl Guessing the dps headers and libraries paths.
dnl
dnl This macro takes one argument, HEADER_or_LIBRARY.
dnl 
dnl If HEADER_or_LIBRARY is "HEADER", this macro guesses 
dnl dps headers directory path and set dps_includes_candidates.
dnl Else this macro guesses dps libraries directory path and 
dnl set dps_libraries_candidates.
dnl
dnl The paths in dps_includes_candidates_default and dps_libraries_candidates_default
dnl are candidates for all platforms.
dnl 
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPS_GUESS,
[dnl
dnl
dnl
dps_includes_candidates_default="/usr/local/include $ac_x_includes"
dps_libraries_candidates_default="/usr/local/lib $ac_x_libraries"
dnl
dnl
dnl
if test "x$1" = xHEADER ; then
        dps_includes_candidates=$dps_includes_candidates_default
else
        dps_libraries_candidates=$dps_libraries_candidates_default
fi
dnl
dnl Add GNUSTEP directories 
dnl
if test x${GNUSTEP_SYSTEM_ROOT} != "x"; then
	if test "x$1" = xHEADER ; then
		AC_PATH_DPS_GUESS_GNUSTEP(HEADER)
                dps_includes_candidates="$dps_includes_candidates_gstep $dps_includes_candidates"
	else
		AC_PATH_DPS_GUESS_GNUSTEP(LIBRARY)
                dps_libraries_candidates="$dps_libraries_candidates_gstep $dps_libraries_candidates"
	fi
fi

dnl
dnl 
dnl
case "$target" in 
dnl (
# Solaris2 has DPS.
# Including openwin headers directory if the OS is Solaris-2.x that has DPS.
# 
 	*-*-solaris2*)
 		if test x$OPENWINHOME = "x"; then
			AC_MSG_WARN(Set OPENWINHOME environment variable.)
                        solaris_dps_root=/usr/openwin
                else
                        solaris_dps_root=${OPENWINHOME}
                fi
		if test "x$1" = xHEADER ; then
                        dps_includes_candidates="$solaris_dps_root/include/X11 $dps_includes_candidates"
        	else
			dps_libraries_candidates="$solaris_dps_root/lib $dps_libraries_candidates"
	
		fi
       ;;
dnl (
# OSF/DigitalUNIX(?) also has DPS.
# 
      	*-*-osf*)	
                osf_dps_root=/usr
		if test "x$1" = xHEADER ; then
			dps_includes_candidates="$osf_dps_root/include $dps_includes_candidates"
		else
			dps_libraries_candidates="$osf_dps_root/shlib $osf_dps_root/lib $dps_libraries_candidates"
		fi
        ;;
dnl (
# AIX also has DPS but we don't have AIX box so, we don't test this macro on
# that platform. If this works file, pls report the author
# (masata-y@is.aist-nara.ac.jp).
#
dnl The AIX related information provided by s-okada.
dnl
dnl AIX 3.2.5
dnl /usr/lpp/DPS/bin
dnl /usr/lpp/DPS/lib
dnl /usr/include/DPS
dnl
dnl About AIX 4.1(Japanese)
dnl http://www.ibm.co.jp/manuals/gc23-3902-02/d3b63114-2.html
dnl 
	*-*-aix*)
		if test "x$1" = xHEADER ; then
			dps_includes_candidates="/usr/include  $dps_includes_candidates"
		else
			dps_libraries_candidates="/usr/lpp/DPS $dps_libraries_candidates"
		fi
	;;
esac])

dnl ----------------------------------------------------------------
dnl * private AC_PATH_DPS_CHECK_LIB
dnl Checking the existence of libdps.a
dnl If existing, set null string to no_dps.
dnl If not existing, set yes to no_dps.
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPS_CHECK_LIB,
[if test "x$no_dps" = xyes; then
dnl DO nothing
	echo -n "" 
elif test "x$no_x" = xyes ; then
        no_dps=yes
elif test "x${x_libraries}" != x ; then
   dps_check_lib_save_libs=$LIBS
   if test "x${dps_libraries}" = x ; then
           for candidate_path in $dps_libraries_candidates 
           do
                LIBS="-ldps -L${candidate_path} -L${x_libraries} -lX11 -lm" 
                AC_TRY_LINK(, [XDPSCreateSimpleContext()], no_dps=, no_dps=yes)

		# Really Found?
		if test "x$no_dps" = x ; then
			if test -f ${candidate_path}/libdps.so ; then
                        # Do nothing
				cd .
			elif test -f ${candidate_path}/libdps.a ; then
                        # Do nothing
				cd .
			else
				no_dps=yes
			fi
		fi

                if test "x$no_dps" = x ; then
                        if test "x${dps_libraries}" = x ; then
                                 dps_libraries=$candidate_path
                                 break
                        fi
                fi
           done
           if test "x${dps_libraries}" != x ; then
                    no_dps=
           fi
   else
           LIBS="-ldps -L${dps_libraries} -L${x_libraries} -lX11 -lm $LIBS" 
           AC_TRY_LINK(, [XDPSCreateSimpleContext()], , no_dps=yes)
   fi
   LIBS=$dps_check_lib_save_libs
else
# We can compile using X headers with no special include directory.
   if test "x${dps_libraries}" = x ; then
           for candidate_path in $dps_libraries_candidates 
           do
               dps_check_lib_save_libs=$LIBS
                LIBS="-ldps -L${candidate_path} -lX11 -lm $LIBS"
                AC_TRY_LINK(, [XDPSCreateSimpleContext()], , no_dps=yes)
                if test "x$no_dps" = x ; then
                        if test "x${dps_libraries}" = x ; then
                                 dps_libraries=$candidate_path
                        fi
                fi
                LIBS=$dps_check_lib_save_libs
           done
           if test "x${dps_libraries}" != x ; then
                    no_dps=
           fi
   else
           dps_check_lib_save_libs=$LIBS
           LIBS="-ldps -L${dps_libraries} -lX11 -lm $LIBS"
           AC_TRY_LINK(, [XDPSCreateSimpleContext()], , no_dps=yes) 
           LIBS=$dps_check_lib_save_libs
   fi
fi])

dnl ----------------------------------------------------------------
dnl * private AC_PATH_DPS_CHECK_HEADER
dnl Checking the existence of DPS/*.h
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPS_CHECK_HEADER, 
[AC_REQUIRE_CPP()
if test "x$no_dps" = xyes ; then
dnl DO nothing
	echo -n "" 
else
	if test "x${dps_includes}" = x ; then
                for candidate_path in $dps_includes_candidates
                do
                    dps_check_lib_save_headers=$CPPFLAGS
                    CPPFLAGS="-I${candidate_path} $CPPFLAGS"
	            AC_TRY_CPP([#include <DPS/dpsfriends.h>], no_dps=, no_dps=yes)
                    if test "x$no_dps" = x ; then
                            if test -f ${candidate_path}/DPS/dpsfriends.h ; then
                                    dps_includes=$candidate_path
                                    CPPFLAGS=$dps_check_lib_save_headers
                                    break
                            fi
                    fi
               	    CPPFLAGS=$dps_check_lib_save_headers    
                done
                if test "x${dps_includes}" != x ; then
                         no_dps=
                fi
        else
        	dps_check_lib_save_headers=$CPPFLAGS
        	CPPFLAGS="-I${dps_includes} $CPPFLAGS"
	        AC_TRY_CPP([#include <DPS/dpsfriends.h>], no_dps=, no_dps=yes)
        	CPPFLAGS=$dps_check_lib_save_headers
        fi
fi])

dnl ----------------------------------------------------------------
dnl * private AC_PATH_DPS_CHECK
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPS_CHECK, 
[AC_PATH_DPS_CHECK_LIB 
if test "x$no_dps" != xyes ; then
	AC_PATH_DPS_CHECK_HEADER
fi])


dnl ----------------------------------------------------------------
dnl * public AC_PATH_DPS
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPS,
[dnl
AC_REQUIRE([AC_PATH_X])
AC_MSG_CHECKING(for DPS)
dnl ------------------------------- Initialize variables
dps_includes=NONE
dps_libraries=NONE

dnl ------------------------------- Option arguments
AC_ARG_WITH(dps,           
	[  --with-dps              use the DPS. Give yes or no. [yes]], ,
                                   with_dps=yes)

AC_ARG_WITH(dps_includes,  
	[  --with-dps-includes=DIR  DPS include files are in DIR/DPS], ,
	with_dps_includes=NONE)

AC_ARG_WITH(dps_libraries, 
	[  --with-dps-libraries=DIR DPS libraries files are in DIR], ,
	with_dps_libraries=NONE)	

dnl ------------------------------- Check the arguments for configure 
dnl ------------------------------- And decide dps_includes&dps_libraries.
if test "x$with_dps" = xno; then
  no_dps=yes
else
  if test "x$dps_includes" != xNONE && test "x$dps_libraries" != xNONE; then
    no_dps=
  else	
    AC_CACHE_VAL(ac_cv_path_dps,
    [dnl ---------------------------- Set defalut value
    no_dps=yes
  
    if test "x$with_dps_includes" = xNONE ; then
        dps_includes=""
  	no_dps=
  	AC_PATH_DPS_GUESS(HEADER)
    else
  	no_dps=
  	dps_includes=$with_dps_includes
    fi
  
    if test "x$with_dps_libraries" = xNONE ; then
        dps_libraries=""
	no_dps=
   	AC_PATH_DPS_GUESS(LIBRARY)
    else
	no_dps=
  	dps_libraries=$with_dps_libraries
    fi
dnl ------------------------------- Test
    AC_PATH_DPS_CHECK
dnl ------------------------------- Generate value for caching
    if test "x$no_dps" = xyes; then
      ac_cv_path_dps="no_dps=yes"
    else
      ac_cv_path_dps="no_dps= ac_dps_includes=$ac_dps_includes ac_dps_libraries=$ac_dps_libraries"
    fi])
dnl ------------------------------- Eval cache value
  fi
  eval "$ac_cv_path_dps"
dnl ------------------------------- Report the result
  if test "x$no_dps" = xyes; then
    AC_MSG_RESULT(no)
  else
    test "x$dps_includes" = xNONE && dps_includes=$ac_dps_includes
    test "x$dps_libraries" = xNONE && dps_libraries=$ac_dps_libraries
    ac_cv_path_dps="no_dps= ac_dps_includes=$dps_includes ac_dps_libraries=$dps_libraries"
    AC_MSG_RESULT([libraries $dps_libraries, headers $dps_includes])
  fi
fi])

dnl ----------------------------------------------------------------
dnl * public AC_CHECK_DPS_NXAGENT
dnl ----------------------------------------------------------------
AC_DEFUN(AC_CHECK_DPS_NXAGENT,
[AC_REQUIRE([AC_PATH_DPS])
if test "x$no_dps" = xyes ; then
dnl Do nothing
	echo -n ""	
else
 	dps_check_lib_save_headers=$CPPFLAGS	
	CPPFLAGS="-I${dps_includes} $CPPFLAGS"
	AC_CHECK_HEADERS(DPS/dpsNXargs.h,
		 no_dps_nxagent_header=, no_dps_nxagent_header=yes)
	CPPFLAGS=$dps_check_lib_save_headers
	
	dps_check_lib_save_libs=$LIBS	
        if test "x${x_libraries}" != x; then
	  LIBS="-ldpstk -ldps -L${dps_libraries} -L${x_libraries} -lX11 -lm $LIBS"
        else
          LIBS="-ldpstk -ldps -L${dps_libraries} -lX11 -lm $LIBS"
        fi
	AC_CHECK_FUNCS(XDPSNXSetClientArg,
		no_dps_nxagent_func=,no_dps_nxagent_func=yes)
	LIBS=$dps_check_lib_save_libs	
	AC_MSG_CHECKING(for DPS NXAGENT)
	if test "x$no_dps_nxagent_header" != xyes && test "x$no_dps_nxagent_func" != xyes ; then
		no_dps_nxagent=
		AC_MSG_RESULT(yes)
	else
		no_dps_nxagent=yes
		AC_MSG_RESULT(no)
	fi
fi])
dnl ----------------------------------------------------------------
dnl * public AC_PATH_DPSET
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PATH_DPSET, 
[AC_REQUIRE([AC_PATH_DPS])
AC_REQUIRE([AC_CHECK_DPS_NXAGENT])
if test "x$no_dps" = xyes ; then
dnl Do nothing
	echo -n ""	
else
	if test "x$no_dps_nxagent" != xyes ; then
		AC_DEFINE(HAVE_DPS_NXAGENT)
	fi
	DPS_CFLAGS=-I${dps_includes}
        DPS_LIBS="-L${dps_libraries} -ldpstk -ldps"
fi
])

dnl ----------------------------------------------------------------
dnl * public AC_PROG_PSWRAP
dnl Set output variable `PSWRAP' to `pswrap' if `pswrap' is found,
dnl otherwise to `' (Empty).
dnl ----------------------------------------------------------------
AC_DEFUN(AC_PROG_PSWRAP,
[AC_CHECK_PROG(PSWRAP, pswrap, pswrap, "")])


dnl ----------------------------------------------------------------
dnl About DPS server and DPS client library.
dnl ----------------------------------------------------------------
dnl
dnl [0] Solaris2, AIX and OSF1 have them. Lucky you!
dnl
dnl [1] HPUX and IRIX have the DPS extension on its X server 
dnl     but I cannot find the client side files for DPS.
dnl     I found libdps.so in /usr/lib on IRIX. But I cannot find header
dnl     files. 
dnl     You should have to install DPS client library by your self.
dnl     The client library is provided by ADOBE. I don't know well about
dnl     it.
dnl 
dnl     [/X11R5/contrib/lib/DPS/include/DPS]
dnl     [/X11R6/contrib/lib/DPS/include/DPS]
dnl
dnl [2] etc... You can check the existence of DPS library by follwing shell 
dnl            command line.
dnl     % which pswrap
dnl     If the command tells the path for pswrap command, the system you are
dnl     using has DPS client library.
dnl       
dnl [3] *BSD, Linux are waitting for the free DPS server implementation 
dnl     named DGS. DGS will be part of gs5.50. Wait!
dnl 
dnl [4] NeXT/Apple/Rapsody?
dnl     I don't know well about it.
dnl
dnl Snapshot of the DGS is already released. It is named dgs-5.20.
dnl 
dnl The directory structcture of dgs-5.20 is reported by s-okada.
dnl I've referred this report to write macros in this file.
dnl
dnl Thu Nov 12 11:32:30 1998: The implementation of DPS in gs5.50 is not
dnl completed yet...sigh.
dnl

dnl <end of path_dps.m4>
