#! gmake

## AbiSource Applications
## Copyright (C) 1998 AbiSource, Inc.
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
## 02111-1307, USA.

##################################################################
## debfonts -- the Unix fonts package in Debian .deb format.

# get the package names we'll use to build with
ABI_DEPTH=../..
include $(ABI_DEPTH)/pkg/common/unix/allfonts.mk

# update this manually?  That sucks
DEB_FONTS_BUILD_COUNTER	= 1

DEB_FONTS_PKGBASENAME		= abisuite-fonts_$(ABI_FONTS_BUILD_VERSION)-$(DEB_FONTS_BUILD_COUNTER)

DPKG_DEB = $(shell [ -x /usr/bin/dpkg-deb ] && echo 1)

ifeq ($(DPKG_DEB),)
deb_fonts::
else 
deb_fonts:
	@echo "* Building .deb package [fonts] ..."
	@$(subst xxxx,$(DIST),$(VERIFY_DIRECTORY))
# create directories
	@$(subst xxxx,$(DIST)/$(DEB_FONTS_PKGBASENAME),$(VERIFY_DIRECTORY))
	@$(subst xxxx,$(DIST)/$(DEB_FONTS_PKGBASENAME)/DEBIAN,$(VERIFY_DIRECTORY))
	@$(subst xxxx,$(DIST)/$(DEB_FONTS_PKGBASENAME)/usr/doc/abisuite-fonts,$(VERIFY_DIRECTORY))
	@$(subst xxxx,$(DIST)/$(DEB_FONTS_PKGBASENAME)/usr/share/abisuite/fonts,$(VERIFY_DIRECTORY))
# turn control-template into control via sed magic
	(sed "s/__ABI_FONTS_VERSION__/$(ABI_FONTS_BUILD_VERSION)-$(DEB_FONTS_BUILD_COUNTER)/" debfonts/control-template \
		> $(DIST)/$(DEB_FONTS_PKGBASENAME)/DEBIAN/control)
# copy all fonts into new tree
	(cd $(OUTDIR)/AbiSuite/fonts/data; tar cf - * ) | (cd $(DIST)/$(DEB_FONTS_PKGBASENAME)/usr/share/abisuite/fonts; tar xf -)
# copy all docs into new tree
	(cd debfonts; tar cf - copyright ) | (cd $(DIST)/$(DEB_FONTS_PKGBASENAME)/usr/doc/abisuite-fonts; tar xf -)
# generate MD5 sums for files after everything is in place
	(cd $(DIST)/$(DEB_FONTS_PKGBASENAME); find . -type f -exec md5sum {} \;) | (sed "s/\.\/usr/usr/") | \
		(grep -v "DEBIAN" > $(DIST)/$(DEB_FONTS_PKGBASENAME)/DEBIAN/md5sums)
# build deb package
	(cd $(DIST); dpkg-deb -b $(DEB_FONTS_PKGBASENAME) $(DEB_FONTS_PKGBASENAME).deb)
	(cd $(DIST); rm -rf $(DEB_FONTS_PKGBASENAME))
endif