/*
 * $Id: comm.h,v 1.4 1999/07/29 20:27:33 malte Exp $
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef	_COMM_H_
#define	_COMM_H_

/*
 * Filename suffix to be appended to uncompress encrypted files
 */
#ifndef	SUFFIX
#define	SUFFIX		".dea"
#endif

/*
 * Filename suffix to be appended to compress encrypted files
 */
#ifndef	COMPFIX
#define	COMPFIX		".dgz"
#endif

/*
 * Path and name of external compression utility
 * Must read from a pipe as stdin and write to stdout and should know a '-v'
 * flag to work in verbose mode.
 */
#ifndef	COMPRESS
#define	COMPRESS	"/vol/gnu/bin/gzip"
#endif

/*
 * Path and name of external decompression utility
 * Must read from stdin and write to a pipe as stdout and should know a '-v'
 * flag to work in verbose mode.
 */
#ifndef	UNCOMPRESS
#define	UNCOMPRESS	"/vol/gnu/bin/zcat"
#endif

/*
 * The names of the environment variables to override the default compression
 * utilities pathnames
 */
#define	ENVCOMPRESS		"DEACOMPRESS"
#define	ENVDECOMPRESS	"DEADECOMPRESS"

extern	char	*prgname;
extern	char	*compress;
extern	int		verbose;

extern	int		keycheck( char * );
extern	int		readkey( char *, int );

extern	int		ioinit( FILE *, FILE *, int, const char * );
extern	int		(*input)( deablk );
extern	int		(*output)( const deablk );

extern	int		filter( int, const char *, int );
extern	int		filtwait( void );

#endif	/* _COMM_H_ */
