/*
 * $Id: dea.c,v 1.7 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: dea.c,v $
 * Revision 1.7  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.6  1994/12/12  16:05:33  malte
 * array indizierung durch pointerarithmetik ersetzt.
 *
 * Revision 1.5  1994/02/25  18:03:06  malte
 * unterscheidung zwischen BYTEADDR und nornmalem adressierungsmodus
 *
 * Revision 1.4  1994/02/23  07:32:37  malte
 * Schnellere Addressierung durch veraendertes sb Macro
 *
 * Revision 1.3  1994/02/19  11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.2  1994/02/19  11:48:59  malte
 * Lesbarkeit verbessert, vor allem aber eine Rotation gespart durch
 * vorausrotieren der S-Boxen um 3 statt 1.
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "intern.h"
#include "sboxes.h"

#if	BYTEADDR
#define	sb( a, b )	*(card *)((Stbl + ((a - 1) << 8)) + ((b) & 0x000000FC))
#else
#define sb( a, b )	*(card *)(((byte *)Sbox[ a - 1 ]) + ((b) & 0x000000FC))
#endif

#define	SPE( X, k1, k2 )	(\
	Y = ror( X, 4 ) ^ k1, Z = X ^ k2,\
	sb( 7, Y ) | sb( 5, Y >> 8 ) | sb( 3, Y >> 16 ) | sb( 1, Y >> 24 )|\
	sb( 8, Z ) | sb( 6, Z >> 8 ) | sb( 4, Z >> 16 ) | sb( 2, Z >> 24 ))

void	dea( deablk blk, const void *keytbl )
{
	const	card	*key = keytbl;
			card	Y, Z;

	CNV( blk ); IP( blk );

	blk[ 0 ] = rol( blk[ 0 ], 3 );
	blk[ 1 ] = rol( blk[ 1 ], 3 );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key++ );

	blk[ 0 ] ^= SPE( blk[ 1 ], *key++, *key++ );
	blk[ 1 ] ^= SPE( blk[ 0 ], *key++, *key   );

	Z = blk[ 1 ];
	blk[ 1 ] = ror( blk[ 0 ], 3 );
	blk[ 0 ] = ror( Z, 3 );

	FP( blk ); CNV( blk );
}
