/*
 * $Id: intern.h,v 1.5 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: intern.h,v $
 * Revision 1.5  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.4  1994/02/25 18:03:06  malte
 * maschinenabhaengigkeiten in machine.h ausgelagert. Damit sind nur noch die
 * lesbarkeits macros hier drin
 *
 * Revision 1.3  1994/02/19  11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.2  1994/02/19  11:48:59  malte
 * Lesbarkeit verbessert, vor allem aber eine Rotation gespart durch
 * vorausrotieren der S-Boxen um 3 statt 1.
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef	_INTERN_H_
#define	_INTERN_H_

#include "dea.h"
#include "machine.h"

#define	tblsize( x )	(sizeof( x )/sizeof( x[0] ))

#define	bitc( n, x )	(((x) >> ( 32 - (n))) & 1 )
#define	bitf( f, n )	bitc( (n - 1) % 32 + 1, (f)[ (n - 1) / 32 ] )

#define	pick6( p, x1, x2, x3, x4, x5, x6 )	(\
	bitf( p, x1 ) << 7 | bitf( p, x2 ) << 6 | bitf( p, x3 ) << 5 |\
	bitf( p, x4 ) << 4 | bitf( p, x5 ) << 3 | bitf( p, x6 ) << 2)

#define	pick7( p, x1, x2, x3, x4, x5, x6, x7 )	\
	(pick6( p, x1, x2, x3, x4, x5, x6 ) | bitf( p, x7 ) << 1)

#define	rol( x, n )	((x) << (n) | (x) >> (32 - (n)))
#define	ror( x, n )	((x) >> (n) | (x) << (32 - (n)))
#define	rok1( x )	((x) << 1 | (x) >> 27)
#define	rok2( x )	((x) << 2 | (x) >> 26)

#define	CNV( z )	(z[ 0 ] = normal( z[0] ), z[ 1 ] = normal( z[1] ))
#define	IP( x )		(swap1( x ), swap2( x ), swap3( x ), swap4( x ), swap5( x ))
#define	FP( x )		(swap5( x ), swap4( x ), swap3( x ), swap2( x ), swap1( x ))

#define	swap1( x )	swap( x[0], x[1],  4, 0x0F0F0F0F )
#define	swap2( x )	swap( x[0], x[1], 16, 0x0000FFFF )
#define	swap3( x )	swap( x[1], x[0],  2, 0x33333333 )
#define	swap4( x )	swap( x[1], x[0],  8, 0x00FF00FF )
#define	swap5( x )	swap( x[0], x[1],  1, 0x55555555 )

#define	swap( x, y, s, m )	(y ^= (Y = ((x >> s) ^ y ) & m ), x ^= Y << s)

#define	str2card( s ) \
((card)(s)[ 0 ] << 24 | (card)(s)[ 1 ] << 16 | (card)(s)[ 2 ] << 8 | (card)(s)[ 3 ])

#ifdef	DEBUG
extern	void	printcb( card ), printch( card );
extern	void	showb( const char *, const card *, int ),
				showc( const char *,	   card  , int ),
				showr( const char *, card, card, int );
#else
#define	printcb( x )
#define	printch( x )
#define	showb( a, b, c )
#define	showc( a, b, c )
#define	showr( a, b, c, d )
#endif

#endif	/* _INTERN_H_ */
