/*
 * $Id: machine.h,v 1.4 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: machine.h,v $
 * Revision 1.4  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.3  1999/01/29 21:29:35  malte
 * replaced machine specific tests with ENDIAN macro
 *
 * Revision 1.2  1994/02/25 18:03:06  malte
 * Kommentare zu den unterwschiedlichen #ifs eingefuegt
 *
 * Revision 1.1  1994/02/25  17:17:55  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef	_MACHINE_H_
#define	_MACHINE_H_

typedef	unsigned	char	byte;
typedef	unsigned	int		card;

#ifdef	BIGENDIAN
# define	normal( x ) (x)
#endif
#ifdef	LITTLEENDIAN
# define	normal( x ) ((x)<<24|((x)&0xFF00)<<8|((x)&0xFF0000)>>8|(x)>>24)
#endif

/* BYTEADDR sagt welche Art der Array-Adressierung guenstiger ist */
#if	defined(__sparc)						/* Sun Sparc v7 */
# define	BYTEADDR	0
#endif

#if	defined(__sgi) && defined(__mips)		/* SGI Mips R[34]000 */
# define	BYTEADDR	1
#endif

#if	defined(___IBMR2) || defined(_IBMR2)	/* IBM RS6000 */
# define	BYTEADDR	1
#endif

#if	defined(__alpha)						/* DEC alpha 2106[46] */
# define	BYTEADDR	0
#endif

#if	defined(__MIPSEL) || defined(__MIPSEL__) /* DEC Mips R3000 */
# define	BYTEADDR	1
#endif

#if	defined(__i386) || defined(__i486) /* Intel [345]86 and compatible */
#endif

#if	!defined(BIGENDIAN) && !defined(LITTLEENDIAN)
#error	unspecified or unknown byte order
#endif

#endif
