/*
 * $Id: sboxgen.c,v 1.6 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: sboxgen.c,v $
 * Revision 1.6  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.5  1994/03/29 15:10:50  malte
 * hex konstanten als 0x??UL ausgeben
 *
 * Revision 1.4  1994/02/25  18:03:06  malte
 * unterscheidung zwischen BYTEADDR und normalem adressierungsmodus
 *
 * Revision 1.3  1994/02/19  11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.2  1994/02/19  11:48:59  malte
 * Lesbarkeit verbessert, vor allem aber eine Rotation gespart durch
 * vorausrotieren der S-Boxen um 3 statt 1.
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include "intern.h"

/*
 * bit substitution tables to make cypher text look "random"
 */

static	byte	tbls[ 8 ][ 4 ][ 16 ] =
{
		/*	static	byte	S1[ 4 ][ 16 ] = */
{
	{ 14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7 },
	{  0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8 },
	{  4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0 },
	{ 15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13 }
},

		/*	static	byte	S2[ 4 ][ 16 ] = */
{
	{ 15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10 },
	{  3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5 },
	{  0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15 },
	{ 13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9 }
},

		/*	static	byte	S3[ 4 ][ 16 ] = */
{
	{ 10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8 },
	{ 13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1 },
	{ 13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7 },
	{  1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12 }
},

		/*	static	byte	S4[ 4 ][ 16 ] = */
{
	{  7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15 },
	{ 13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9 },
	{ 10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4 },
	{  3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14 }
},

		/*	static	byte	S5[ 4 ][ 16 ] = */
{
	{  2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9 },
	{ 14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6 },
	{  4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14 },
	{ 11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3 }
},

		/*	static	byte	S6[ 4 ][ 16 ] = */
{
	{ 12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11 },
	{ 10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8 },
	{  9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6 },
	{  4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13 }
},

		/*	static	byte	S7[ 4 ][ 16 ] = */
{
	{  4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1 },
	{ 13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6 },
	{  1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2 },
	{  6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12 }
},

		/*	static	byte	S8[ 4 ][ 16 ] = */
{
	{ 13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7 },
	{  1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2 },
	{  7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8 },
	{  2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11 }
}
};

static
card	Perm( card b )
{
	card	o;

	o = bitc( 16, b ) << 31 | bitc(  7, b ) << 30 | bitc( 20, b ) << 29 |
		bitc( 21, b ) << 28 | bitc( 29, b ) << 27 | bitc( 12, b ) << 26 |
		bitc( 28, b ) << 25 | bitc( 17, b ) << 24 | bitc(  1, b ) << 23 |
		bitc( 15, b ) << 22 | bitc( 23, b ) << 21 | bitc( 26, b ) << 20 |
		bitc(  5, b ) << 19 | bitc( 18, b ) << 18 | bitc( 31, b ) << 17 |
		bitc( 10, b ) << 16 | bitc(  2, b ) << 15 | bitc(  8, b ) << 14 |
		bitc( 24, b ) << 13 | bitc( 14, b ) << 12 | bitc( 32, b ) << 11 |
		bitc( 27, b ) << 10 | bitc(  3, b ) <<  9 | bitc(  9, b ) <<  8 |
		bitc( 19, b ) <<  7 | bitc( 13, b ) <<  6 | bitc( 30, b ) <<  5 |
		bitc(  6, b ) <<  4 | bitc( 22, b ) <<  3 | bitc( 11, b ) <<  2 |
		bitc(  4, b ) <<  1 | bitc( 25, b );

	return rol( o, 3 );
}

#define	row( x )	(((card)(x) & 0x00000020) >> 4 | ((card)(x) & 1))
#define	col( x )	(((card)(x) & 0x0000001e) >> 1)
#define	place( x, r, c )	(((card)tbls[ x - 1 ][ r ][ c ]) << ( 32 - x * 4 ))

static
void	subst( unsigned Y )
{
	card	n, cnv;

	(void)printf( "{\n" );

	for( n = 0; n < 64; n++ )
	{
		cnv = place( Y, row( n ), col( n ));
		(void)printf( "0x%08XUL,%c", Perm( cnv ), (( n & 3 ) == 3 ) ? '\n' : ' ' );
	}
	(void)printf( "},\n" );
}

int		main( void )
{
	(void)printf( "static\tcard\tSbox[ 8 ][ 64 ] = {\n" );

	subst( 1 ); subst( 2 ); subst( 3 ); subst( 4 );
	subst( 5 ); subst( 6 ); subst( 7 ); subst( 8 );

	(void)printf( "};\n" );

#if	BYTEADDR
	(void)printf( "static\tbyte\t*Stbl = (byte *)Sbox;\n" );
#endif

	return 0;
}
