/*
 * $Id: sched.c,v 1.4 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: sched.c,v $
 * Revision 1.4  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.3  1994/02/19 11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdlib.h>
#include "intern.h"

#define	rolk( k, n )	((n == 1) ? rok1( k ) : rok2( k ))

static
void	pc2( card *o, const card *i )
{
	o[ 0 ] = pick6( i, 14, 17, 11, 24,  1,  5 ) /* 1 */ << 24
		   | pick6( i, 23, 19, 12,  4, 26,  8 ) /* 3 */ << 16
		   | pick6( i, 45, 56, 35, 41, 51, 59 ) /* 5 */ << 8
		   | pick6( i, 48, 53, 43, 60, 38, 57 ) /* 7 */ << 0;

	o[ 1 ] = pick6( i,  3, 28, 15,  6, 21, 10 ) /* 2 */ << 24
		   | pick6( i, 16,  7, 27, 20, 13,  2 ) /* 4 */ << 16
		   | pick6( i, 34, 44, 55, 49, 37, 52 ) /* 6 */ << 8
		   | pick6( i, 50, 46, 54, 40, 33, 36 ) /* 8 */ << 0;

	showb( "pc2    : ", o, 1 );
}

static
void	pc1( card *in )
{
	card	res[ 2 ];

	res[ 0 ] = pick7( in, 57, 49, 41, 33, 25, 17,  9 ) << 24
			 | pick7( in,  1, 58, 50, 42, 34, 26, 18 ) << 17
			 | pick7( in, 10,  2, 59, 51, 43, 35, 27 ) << 10
			 | pick7( in, 19, 11,  3, 60, 52, 44, 36 ) << 3;

	res[ 1 ] = pick7( in, 63, 55, 47, 39, 31, 23, 15 ) << 24
			 | pick7( in,  7, 62, 54, 46, 38, 30, 22 ) << 17
			 | pick7( in, 14,  6, 61, 53, 45, 37, 29 ) << 10
			 | pick7( in, 21, 13,  5, 28, 20, 12,  4 ) << 3;

	showb( "pc1    : ", res, 1 );

	in[ 0 ] = res[ 0 ], in[ 1 ] = res[ 1 ];
}

static	card	rot[ 16 ] = { 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1 };

void	*dea_keytab( void )
{
	return malloc( 2 * tblsize( rot ) * sizeof( card ));
}

void	dea_schedule( const byte *str, int how, void *keytab )
{
#define		keytbl	((card *)keytab)
	card	key[ 2 ], i;
	int		indx, next;

	key[ 0 ] = str2card( str );
	key[ 1 ] = str2card( str + 4 );

	if(( how & DEAENCRYPT ) != 0 )
		indx = 0, next = 2;
	else
		indx = 2 * tblsize( rot ) - 2, next = -2;

	showb( "key    : ", key, 0 );

	pc1( key );

	for( i = 0; i < tblsize( rot ); i++ )
	{
		key[ 0 ] = rolk( key[ 0 ], rot[ i ] );
		key[ 1 ] = rolk( key[ 1 ], rot[ i ] );

		pc2( keytbl + indx, key );
		indx += next;
	}
}
