/*
 * $Id: speed.c,v 1.4 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: speed.c,v $
 * Revision 1.4  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.3  1994/02/19 11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.2  1994/02/19  11:48:59  malte
 * Genauigkeit der Ausgabe war zu hoch, 10tel Microsekunden muessen reichen
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>

#include "dea.h"

#define	KEYTIME		4
#define	CRYPTTIME	10

static	unsigned	char	key[ 9 ] = "dotestme";
static				deablk	data;

static	volatile	int		alarm;

static
void	catchsig( int sig )
{
	alarm = sig;
}

static
void	setsignals( void )
{
	struct	sigaction	act;

	act.sa_handler = catchsig;
	act.sa_flags   = 0;
	(void)sigfillset( &act.sa_mask );

	if( sigaction( SIGVTALRM, &act, NULL ))
	{
		perror( "sigaction" );
		exit( 1 );
	}
}

static
void	setalarm( unsigned sec )
{
	struct	itimerval	itv;

	itv.it_value.tv_sec  = (long)sec;
	itv.it_value.tv_usec = 0L;
	itv.it_interval.tv_sec  = 0L;
	itv.it_interval.tv_usec = 0L;

	if(( alarm = setitimer( ITIMER_VIRTUAL, &itv, NULL )) != 0 )
		perror( "setitimer" );
}

int		main( void )
{
	double		runs;
	unsigned	n;
	void		*keytab = dea_keytab();

	setsignals();

	for( setalarm( KEYTIME ), n = 0; alarm == 0; n++ )
		dea_schedule( key, DEAENCRYPT, keytab );

	runs = (double)n / (double)KEYTIME;
	(void)printf( "key schedule = %9.1f keys/s   = %6.1f us/key\n",
		runs,  1e6 / runs );

	for( setalarm( CRYPTTIME ), n = 0; alarm == 0; n++ )
		dea( data, keytab );

	runs = (double)n / (double)CRYPTTIME;
	(void)printf( "crypt        = %9.1f crypts/s = %6.1f us/crypt = %.1f KB/s\n",
		runs, 1e6 / runs, ((double)sizeof( data ) * runs) / 1024.0 );

	return 0;
}
